/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class StructuredCoder<@UnknownKeyFor T>
extends Coder<T> {
    protected StructuredCoder() {
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getComponents() {
        return this.getCoderArguments();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructuredCoder that = (StructuredCoder)o;
        return this.getComponents().equals(that.getComponents());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.getClass().hashCode() * 31 + this.getComponents().hashCode();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder();
        String s = this.getClass().getName();
        builder.append(s.substring(s.lastIndexOf(46) + 1));
        List<Coder<?>> componentCoders = this.getComponents();
        if (!componentCoders.isEmpty()) {
            builder.append('(');
            boolean first = true;
            for (Coder<?> componentCoder : componentCoders) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(componentCoder.toString());
            }
            builder.append(')');
        }
        return builder.toString();
    }
}

