/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.client;

import java.util.ArrayList;
import java.util.List;
import org.monetdb.util.Exporter;

final class Table {
    final String schem;
    final String name;
    final String type;
    final String fqname;
    final ArrayList<Table> needs = new ArrayList();

    Table(String string, String string2, String string3) {
        this.schem = string;
        this.name = string2;
        this.type = string3;
        this.fqname = string + "." + string2;
    }

    void addDependency(Table table) throws Exception {
        if (this.fqname.equals(table.fqname)) {
            throw new Exception("Cyclic dependency graphs are not supported (foreign key relation references self)");
        }
        if (table.needs.contains(this)) {
            throw new Exception("Cyclic dependency graphs are not supported (foreign key relation a->b and b->a)");
        }
        if (!this.needs.contains(table)) {
            this.needs.add(table);
        }
    }

    List<Table> requires(List<Table> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<Table>(this.needs);
        }
        ArrayList<Table> arrayList = new ArrayList<Table>();
        for (Table table : this.needs) {
            if (list.contains(table)) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    final String getSchem() {
        return this.schem;
    }

    final String getName() {
        return this.name;
    }

    final String getType() {
        return this.type;
    }

    final String getFqname() {
        return this.fqname;
    }

    final String getFqnameQ() {
        return Exporter.dq(this.schem) + "." + Exporter.dq(this.name);
    }

    public final String toString() {
        return this.fqname;
    }

    static final Table findTable(String string, String string2, List<Table> list) {
        for (Table table : list) {
            if (!table.schem.equals(string) || !table.name.equals(string2)) continue;
            return table;
        }
        return null;
    }

    static final void checkForLoop(Table table, List<Table> list) throws Exception {
        list.add(table);
        for (int i = 0; i < table.needs.size(); ++i) {
            Table table2 = table.needs.get(i);
            if (list.contains(table2)) {
                throw new Exception("Cyclic dependency graphs are not supported (cycle detected for " + table2.fqname + ")");
            }
            Table.checkForLoop(table2, list);
        }
    }
}

