/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ProgramParameter
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int PASS_BY_VALUE = 1;
    public static final int PASS_BY_REFERENCE = 2;
    static final int NULL = 255;
    static final int INPUT = 1;
    static final int OUTPUT = 2;
    static final int INOUT = 3;
    private int parameterType_ = 1;
    private boolean nullParameter_ = true;
    private byte[] inputData_ = null;
    private int outputDataLength_ = 0;
    private byte[] outputData_ = null;
    transient int length_ = 0;
    transient int maxLength_ = 0;
    transient int usage_ = 0;
    transient byte[] compressedInputData_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_;
    private transient VetoableChangeSupport vetoableChangeListeners_;

    public ProgramParameter() {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Constructing ProgramParameter object.");
        }
    }

    public ProgramParameter(byte[] inputData) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, input data:", inputData);
        }
        this.nullParameter_ = false;
        this.inputData_ = inputData;
    }

    public ProgramParameter(int outputDataLength) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, output data length:", outputDataLength);
        }
        if (outputDataLength < 0) {
            Trace.log(2, (Object)this, "Value of parameter 'outputDataLength' is not valid:", outputDataLength);
            throw new ExtendedIllegalArgumentException("outputDataLength (" + outputDataLength + ")", 2);
        }
        this.nullParameter_ = false;
        this.outputDataLength_ = outputDataLength;
    }

    public ProgramParameter(byte[] inputData, int outputDataLength) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, output data length: " + outputDataLength + " input data:", inputData);
        }
        if (outputDataLength < 0) {
            Trace.log(2, (Object)this, "Value of parameter 'outputDataLength' is not valid:", outputDataLength);
            throw new ExtendedIllegalArgumentException("outputDataLength (" + outputDataLength + ")", 2);
        }
        this.nullParameter_ = false;
        this.inputData_ = inputData;
        this.outputDataLength_ = outputDataLength;
    }

    public ProgramParameter(int parameterType, byte[] inputData) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, service program parameter type: " + parameterType + " input data:", inputData);
        }
        if (parameterType < 1 || parameterType > 2) {
            Trace.log(2, (Object)this, "Value of parameter 'parameterType' is not valid:", parameterType);
            throw new ExtendedIllegalArgumentException("parameterType (" + parameterType + ")", 2);
        }
        this.parameterType_ = parameterType;
        this.nullParameter_ = false;
        this.inputData_ = inputData;
    }

    public ProgramParameter(int parameterType, int outputDataLength) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, service program parameter type: " + parameterType + " output data length:", outputDataLength);
        }
        if (parameterType < 1 || parameterType > 2) {
            Trace.log(2, (Object)this, "Value of parameter 'parameterType' is not valid:", parameterType);
            throw new ExtendedIllegalArgumentException("parameterType (" + parameterType + ")", 2);
        }
        if (outputDataLength < 0) {
            Trace.log(2, (Object)this, "Value of parameter 'outputDataLength' is not valid:", outputDataLength);
            throw new ExtendedIllegalArgumentException("outputDataLength (" + outputDataLength + ")", 2);
        }
        this.parameterType_ = parameterType;
        this.nullParameter_ = false;
        this.outputDataLength_ = outputDataLength;
    }

    public ProgramParameter(int parameterType, byte[] inputData, int outputDataLength) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, service program parameter type: " + parameterType + " output data length: " + outputDataLength + " input data:", inputData);
        }
        if (parameterType < 1 || parameterType > 2) {
            Trace.log(2, (Object)this, "Value of parameter 'parameterType' is not valid:", parameterType);
            throw new ExtendedIllegalArgumentException("parameterType (" + parameterType + ")", 2);
        }
        if (outputDataLength < 0) {
            Trace.log(2, (Object)this, "Value of parameter 'outputDataLength' is not valid:", outputDataLength);
            throw new ExtendedIllegalArgumentException("outputDataLength (" + outputDataLength + ")", 2);
        }
        this.parameterType_ = parameterType;
        this.nullParameter_ = false;
        this.inputData_ = inputData;
        this.outputDataLength_ = outputDataLength;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, this, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ == null) {
            this.propertyChangeListeners_ = new PropertyChangeSupport(this);
        }
        this.propertyChangeListeners_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, this, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ == null) {
            this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
        }
        this.vetoableChangeListeners_.addVetoableChangeListener(listener);
    }

    int getMaxLength() {
        int maxLength;
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Getting max length.");
        }
        int n = maxLength = this.inputData_ == null ? this.outputDataLength_ : Math.max(this.inputData_.length, this.outputDataLength_);
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Max length:", maxLength);
        }
        return maxLength;
    }

    public byte[] getInputData() {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Getting input data:", this.inputData_);
        }
        return this.inputData_;
    }

    public byte[] getOutputData() {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Getting output data.");
        }
        return this.outputData_;
    }

    public int getOutputDataLength() {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Getting output data length:", this.outputDataLength_);
        }
        return this.outputDataLength_;
    }

    public int getParameterType() {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Getting parameter type:", this.parameterType_);
        }
        return this.parameterType_;
    }

    int getUsage() {
        int usage;
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Getting parameter usage.");
        }
        int n = this.nullParameter_ ? 255 : (this.outputDataLength_ == 0 ? 1 : (usage = this.inputData_ == null ? 2 : 3));
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Parameter usage:", usage);
        }
        return usage;
    }

    public boolean isNullParameter() {
        if (Trace.traceOn_) {
            Trace.log(1, (Object)this, "Checking if null parameter:", this.nullParameter_);
        }
        return this.nullParameter_;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "De-serializing ProgramParameter object.");
        }
        in.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, this, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, this, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public void setInputData(byte[] inputData) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Setting input data:", inputData);
        }
        byte[] oldValue = this.inputData_;
        byte[] newValue = inputData;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("inputData", oldValue, newValue);
        }
        this.nullParameter_ = false;
        this.inputData_ = inputData;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("inputData", oldValue, newValue);
        }
    }

    public void setNullParameter(boolean nullParameter) {
        if (Trace.traceOn_) {
            Trace.log(1, (Object)this, "Setting null parameter:", nullParameter);
        }
        this.nullParameter_ = nullParameter;
        this.inputData_ = null;
        this.outputDataLength_ = 0;
    }

    void setOutputData(byte[] outputData) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Setting output data:", outputData);
        }
        this.outputData_ = outputData;
    }

    public void setOutputDataLength(int outputDataLength) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Setting output data length:", outputDataLength);
        }
        if (outputDataLength < 0) {
            Trace.log(2, (Object)this, "Value of parameter 'outputDataLength' is not valid:", outputDataLength);
            throw new ExtendedIllegalArgumentException("outputDataLength (" + outputDataLength + ")", 2);
        }
        Integer oldValue = null;
        Integer newValue = null;
        if (this.vetoableChangeListeners_ != null || this.propertyChangeListeners_ != null) {
            oldValue = this.outputDataLength_;
            newValue = outputDataLength;
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("outputDataLength", oldValue, newValue);
        }
        this.nullParameter_ = false;
        this.outputDataLength_ = outputDataLength;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("outputDataLength", oldValue, newValue);
        }
    }

    public void setParameterType(int parameterType) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Setting parameter type:", parameterType);
        }
        if (parameterType < 1 || parameterType > 2) {
            Trace.log(2, (Object)this, "Value of parameter 'parameterType' is not valid:", parameterType);
            throw new ExtendedIllegalArgumentException("parameterType (" + parameterType + ")", 2);
        }
        Integer oldValue = null;
        Integer newValue = null;
        if (this.vetoableChangeListeners_ != null || this.propertyChangeListeners_ != null) {
            oldValue = this.parameterType_;
            newValue = parameterType;
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("parameterType", oldValue, newValue);
        }
        this.parameterType_ = parameterType;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("parameterType", oldValue, newValue);
        }
    }
}

