/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.utils;

import io.confluent.common.utils.PerformanceStats;

public abstract class AbstractPerformanceTest {
    private static final long NS_PER_MS = 1000000L;
    private static final long NS_PER_SEC = 1000000000L;
    private static final long MIN_SLEEP_NS = 2000000L;
    private static final long TARGET_RATE_UPDATE_PERIOD_MS = 100L;
    protected PerformanceStats stats;
    protected long targetIterationRate = 0L;

    public AbstractPerformanceTest(long numEvents, int reportingInterval) {
        this.stats = new PerformanceStats(numEvents, reportingInterval);
    }

    public AbstractPerformanceTest(long numEvents) {
        this(numEvents, 5000);
    }

    protected abstract void doIteration(PerformanceStats.Callback var1);

    protected abstract boolean finished(int var1);

    protected abstract boolean runningFast(int var1, float var2);

    protected float getTargetIterationRate(int iteration, float elapsed) {
        return this.targetIterationRate;
    }

    protected void run() throws InterruptedException {
        long start;
        long sleepDeficitNs = 0L;
        long targetRateUpdated = start = System.currentTimeMillis();
        float currentTargetRate = this.getTargetIterationRate(0, 0.0f);
        long sleepTime = (long)(1.0E9f / currentTargetRate);
        int i = 0;
        while (!this.finished(i)) {
            long sendStart = System.currentTimeMillis();
            if (currentTargetRate > 0.0f) {
                float elapsed = (float)(sendStart - start) / 1000.0f;
                if (i == 1 || i > 1 && sendStart - targetRateUpdated > 100L) {
                    currentTargetRate = this.getTargetIterationRate(i, elapsed);
                    sleepTime = (long)(1.0E9f / currentTargetRate);
                    targetRateUpdated = sendStart;
                }
                if (i > 0 && elapsed > 0.0f && this.runningFast(i, elapsed) && (sleepDeficitNs += sleepTime) >= 2000000L) {
                    long sleepMs = sleepDeficitNs / 1000000L;
                    long sleepNs = sleepDeficitNs - sleepMs * 1000000L;
                    Thread.sleep(sleepMs, (int)sleepNs);
                    sleepDeficitNs = 0L;
                }
            }
            PerformanceStats.Callback cb = this.stats.nextCompletion(sendStart);
            this.doIteration(cb);
            ++i;
        }
        this.stats.printTotal();
    }

    protected void run(long iterationsPerSec) throws InterruptedException {
        this.targetIterationRate = iterationsPerSec;
        this.run();
    }
}

