/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.Sets;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ResourceWatcher;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileSnitch
extends AbstractNetworkTopologySnitch {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileSnitch.class);
    public static final String SNITCH_PROPERTIES_FILENAME = "cassandra-topology.properties";
    private static final int DEFAULT_REFRESH_PERIOD_IN_SECONDS = 5;
    private static volatile Map<InetAddressAndPort, String[]> endpointMap;
    private static volatile String[] defaultDCRack;
    private volatile boolean gossipStarted;

    public PropertyFileSnitch() throws ConfigurationException {
        this(5);
    }

    public PropertyFileSnitch(int refreshPeriodInSeconds) throws ConfigurationException {
        this.reloadConfiguration(false);
        try {
            FBUtilities.resourceToFile(SNITCH_PROPERTIES_FILENAME);
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws ConfigurationException {
                    PropertyFileSnitch.this.reloadConfiguration(true);
                }
            };
            ResourceWatcher.watch(SNITCH_PROPERTIES_FILENAME, runnable, refreshPeriodInSeconds * 1000);
        }
        catch (ConfigurationException ex) {
            logger.error("{} found, but does not look like a plain file. Will not watch it for changes", (Object)SNITCH_PROPERTIES_FILENAME);
        }
    }

    public static String[] getEndpointInfo(InetAddressAndPort endpoint) {
        String[] rawEndpointInfo = PropertyFileSnitch.getRawEndpointInfo(endpoint);
        if (rawEndpointInfo == null) {
            throw new RuntimeException("Unknown host " + endpoint + " with no default configured");
        }
        return rawEndpointInfo;
    }

    private static String[] getRawEndpointInfo(InetAddressAndPort endpoint) {
        String[] value = endpointMap.get(endpoint);
        if (value == null) {
            logger.trace("Could not find end point information for {}, will use default", (Object)endpoint);
            return defaultDCRack;
        }
        return value;
    }

    @Override
    public String getDatacenter(InetAddressAndPort endpoint) {
        String[] info = PropertyFileSnitch.getEndpointInfo(endpoint);
        assert (info != null) : "No location defined for endpoint " + endpoint;
        return info[0];
    }

    @Override
    public String getRack(InetAddressAndPort endpoint) {
        String[] info = PropertyFileSnitch.getEndpointInfo(endpoint);
        assert (info != null) : "No location defined for endpoint " + endpoint;
        return info[1];
    }

    public void reloadConfiguration(boolean isUpdate) throws ConfigurationException {
        HashMap<InetAddressAndPort, String[]> reloadedMap = new HashMap<InetAddressAndPort, String[]>();
        String[] reloadedDefaultDCRack = null;
        Properties properties = new Properties();
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(SNITCH_PROPERTIES_FILENAME);){
            properties.load(stream);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to read cassandra-topology.properties", e);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            InetAddressAndPort host;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ("default".equals(key)) {
                String[] newDefault = value.split(":");
                if (newDefault.length < 2) {
                    reloadedDefaultDCRack = new String[]{"default", "default"};
                    continue;
                }
                reloadedDefaultDCRack = new String[]{newDefault[0].trim(), newDefault[1].trim()};
                continue;
            }
            String hostString = StringUtils.remove((String)key, (char)'/');
            try {
                host = InetAddressAndPort.getByName(hostString);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown host " + hostString, e);
            }
            String[] token = value.split(":");
            token = token.length < 2 ? new String[]{"default", "default"} : new String[]{token[0].trim(), token[1].trim()};
            reloadedMap.put(host, token);
        }
        InetAddressAndPort broadcastAddress = FBUtilities.getBroadcastAddressAndPort();
        String[] localInfo = (String[])reloadedMap.get(broadcastAddress);
        if (reloadedDefaultDCRack == null && localInfo == null) {
            throw new ConfigurationException(String.format("Snitch definitions at %s do not define a location for this node's broadcast address %s, nor does it provides a default", SNITCH_PROPERTIES_FILENAME, broadcastAddress));
        }
        InetAddressAndPort localAddress = FBUtilities.getLocalAddressAndPort();
        if (!localAddress.equals(broadcastAddress) && !reloadedMap.containsKey(localAddress)) {
            reloadedMap.put(localAddress, localInfo);
        }
        if (isUpdate && !PropertyFileSnitch.livenessCheck(reloadedMap, reloadedDefaultDCRack)) {
            return;
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<InetAddressAndPort, String[]> entry : reloadedMap.entrySet()) {
                sb.append(entry.getKey()).append(':').append(Arrays.toString(entry.getValue())).append(", ");
            }
            logger.trace("Loaded network topology from property file: {}", (Object)StringUtils.removeEnd((String)sb.toString(), (String)", "));
        }
        defaultDCRack = reloadedDefaultDCRack;
        endpointMap = reloadedMap;
        if (StorageService.instance != null) {
            if (isUpdate) {
                StorageService.instance.updateTopology();
            } else {
                StorageService.instance.getTokenMetadata().invalidateCachedRings();
            }
        }
        if (this.gossipStarted) {
            StorageService.instance.gossipSnitchInfo();
        }
    }

    private static boolean livenessCheck(HashMap<InetAddressAndPort, String[]> reloadedMap, String[] reloadedDefaultDCRack) {
        Sets.SetView hosts = Arrays.equals(defaultDCRack, reloadedDefaultDCRack) ? Sets.intersection(StorageService.instance.getLiveRingMembers(), (Set)Sets.union(endpointMap.keySet(), reloadedMap.keySet())) : StorageService.instance.getLiveRingMembers();
        for (InetAddressAndPort host : hosts) {
            Object[] updateValue;
            Object[] origValue = endpointMap.containsKey(host) ? endpointMap.get(host) : defaultDCRack;
            if (Arrays.equals(origValue, updateValue = reloadedMap.containsKey(host) ? reloadedMap.get(host) : reloadedDefaultDCRack)) continue;
            logger.error("Cannot update data center or rack from {} to {} for live host {}, property file NOT RELOADED", new Object[]{origValue, updateValue, host});
            return false;
        }
        return true;
    }

    @Override
    public void gossiperStarting() {
        this.gossipStarted = true;
    }
}

