/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.hash.HashJoinIteratorBase;
import org.apache.flink.runtime.operators.hash.MutableHashTable;
import org.apache.flink.runtime.operators.util.JoinTaskIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public class NonReusingBuildSecondHashJoinIterator<V1, V2, O>
extends HashJoinIteratorBase
implements JoinTaskIterator<V1, V2, O> {
    protected final MutableHashTable<V2, V1> hashJoin;
    protected final TypeSerializer<V1> probeSideSerializer;
    private final MemoryManager memManager;
    private final MutableObjectIterator<V1> firstInput;
    private final MutableObjectIterator<V2> secondInput;
    private final boolean buildSideOuterJoin;
    private final boolean probeSideOuterJoin;
    private volatile boolean running = true;

    public NonReusingBuildSecondHashJoinIterator(MutableObjectIterator<V1> firstInput, MutableObjectIterator<V2> secondInput, TypeSerializer<V1> serializer1, TypeComparator<V1> comparator1, TypeSerializer<V2> serializer2, TypeComparator<V2> comparator2, TypePairComparator<V1, V2> pairComparator, MemoryManager memManager, IOManager ioManager, AbstractInvokable ownerTask, double memoryFraction, boolean probeSideOuterJoin, boolean buildSideOuterJoin, boolean useBitmapFilters) throws MemoryAllocationException {
        this.memManager = memManager;
        this.firstInput = firstInput;
        this.secondInput = secondInput;
        this.probeSideSerializer = serializer1;
        if (useBitmapFilters && probeSideOuterJoin) {
            throw new IllegalArgumentException("Bitmap filter may not be activated for joining with empty build side");
        }
        this.probeSideOuterJoin = probeSideOuterJoin;
        this.buildSideOuterJoin = buildSideOuterJoin;
        this.hashJoin = this.getHashJoin(serializer2, comparator2, serializer1, comparator1, pairComparator, memManager, ioManager, ownerTask, memoryFraction, useBitmapFilters);
    }

    @Override
    public void open() throws IOException, MemoryAllocationException, InterruptedException {
        this.hashJoin.open(this.secondInput, this.firstInput, this.buildSideOuterJoin);
    }

    @Override
    public void close() {
        this.hashJoin.close();
        List<MemorySegment> segments = this.hashJoin.getFreedMemory();
        this.memManager.release(segments);
    }

    @Override
    public boolean callWithNextKey(FlatJoinFunction<V1, V2, O> matchFunction, Collector<O> collector) throws Exception {
        if (this.hashJoin.nextRecord()) {
            MutableObjectIterator<V2> buildSideIterator = this.hashJoin.getBuildSideIterator();
            V1 probeRecord = this.hashJoin.getCurrentProbeRecord();
            Object nextBuildSideRecord = buildSideIterator.next();
            if (probeRecord != null && nextBuildSideRecord != null) {
                Object tmpRec = buildSideIterator.next();
                if (tmpRec != null) {
                    Object probeCopy = this.probeSideSerializer.copy(probeRecord);
                    matchFunction.join(probeCopy, nextBuildSideRecord, collector);
                    probeCopy = this.probeSideSerializer.copy(probeRecord);
                    matchFunction.join(probeCopy, tmpRec, collector);
                    while (this.running && (nextBuildSideRecord = buildSideIterator.next()) != null) {
                        probeCopy = this.probeSideSerializer.copy(probeRecord);
                        matchFunction.join(probeCopy, nextBuildSideRecord, collector);
                    }
                } else {
                    matchFunction.join(probeRecord, nextBuildSideRecord, collector);
                }
            } else {
                if (this.probeSideOuterJoin && probeRecord != null && nextBuildSideRecord == null) {
                    matchFunction.join(probeRecord, null, collector);
                }
                if (this.buildSideOuterJoin && probeRecord == null && nextBuildSideRecord != null) {
                    matchFunction.join(null, nextBuildSideRecord, collector);
                    while (this.running && (nextBuildSideRecord = buildSideIterator.next()) != null) {
                        matchFunction.join(null, nextBuildSideRecord, collector);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void abort() {
        this.running = false;
        this.hashJoin.abort();
    }
}

