/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.IDFilter;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;

public abstract class XSLGeneralIncorporate
extends StyleElement {
    String href;
    DocumentImpl includedDoc;

    public abstract boolean isImport();

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string = this.getNamePool().getClarkName(n);
            if (string == "href") {
                this.href = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (this.href == null) {
            this.reportAbsence("href");
        }
    }

    public void validate() throws XPathException {
        this.checkEmpty();
        this.checkTopLevel(null);
    }

    public XSLStylesheet getIncludedStylesheet(XSLStylesheet xSLStylesheet, int n) throws XPathException {
        if (this.href == null) {
            return null;
        }
        this.checkEmpty();
        this.checkTopLevel(this instanceof XSLInclude ? "XTSE0170" : "XTSE0190");
        try {
            Object object;
            Source source;
            XSLStylesheet xSLStylesheet2 = (XSLStylesheet)this.getParent();
            PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
            URIResolver uRIResolver = preparedStylesheet.getURIResolver();
            Configuration configuration = preparedStylesheet.getConfiguration();
            String string = this.href;
            String string2 = null;
            int n2 = string.indexOf(35);
            if (n2 == 0) {
                this.compileError("A stylesheet cannot " + this.getLocalPart() + " itself", this instanceof XSLInclude ? "XTSE0180" : "XTSE0210");
            } else if (n2 == string.length() - 1) {
                string = string.substring(0, n2);
            } else if (n2 > 0) {
                string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
            try {
                source = uRIResolver.resolve(string, this.getBaseURI());
            }
            catch (TransformerException transformerException) {
                throw StaticError.makeStaticError(transformerException);
            }
            if (source == null) {
                source = configuration.getSystemURIResolver().resolve(string, this.getBaseURI());
            }
            if (string2 != null) {
                object = new IDFilter(string2);
                source = AugmentedSource.makeAugmentedSource(source);
                ((AugmentedSource)source).addFilter((ProxyReceiver)object);
            }
            if (source.getSystemId() != null) {
                for (object = xSLStylesheet2; object != null; object = ((XSLStylesheet)object).getImporter()) {
                    if (!source.getSystemId().equals(((ElementImpl)object).getSystemId())) continue;
                    this.compileError("A stylesheet cannot " + this.getLocalPart() + " itself", this instanceof XSLInclude ? "XTSE0180" : "XTSE0210");
                    return null;
                }
            }
            StyleNodeFactory styleNodeFactory = new StyleNodeFactory(configuration);
            this.includedDoc = PreparedStylesheet.loadStylesheetModule(source, configuration, this.getNamePool(), styleNodeFactory);
            ElementImpl elementImpl = this.includedDoc.getDocumentElement();
            if (elementImpl instanceof LiteralResultElement) {
                this.includedDoc = ((LiteralResultElement)elementImpl).makeStylesheet(this.getPreparedStylesheet(), styleNodeFactory);
                elementImpl = this.includedDoc.getDocumentElement();
            }
            if (!(elementImpl instanceof XSLStylesheet)) {
                this.compileError("Included document " + this.href + " is not a stylesheet", "XTSE0165");
                return null;
            }
            XSLStylesheet xSLStylesheet3 = (XSLStylesheet)elementImpl;
            if (xSLStylesheet3.validationError != null) {
                if (this.reportingCircumstances == 1) {
                    xSLStylesheet3.compileError(xSLStylesheet3.validationError);
                } else if (xSLStylesheet3.reportingCircumstances == 2) {
                    xSLStylesheet3.compileError(xSLStylesheet3.validationError);
                }
            }
            xSLStylesheet3.setPrecedence(n);
            xSLStylesheet3.setImporter(xSLStylesheet);
            xSLStylesheet3.spliceIncludes();
            xSLStylesheet2.setInputTypeAnnotations(xSLStylesheet3.getInputTypeAnnotationsAttribute() | xSLStylesheet3.getInputTypeAnnotations());
            return xSLStylesheet3;
        }
        catch (XPathException xPathException) {
            xPathException.setErrorCode("XTSE0165");
            this.compileError(xPathException);
            return null;
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        return null;
    }
}

