/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import net.sf.saxon.codenorm.Normalizer;
import net.sf.saxon.event.HTMLURIEscaper;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;

public class XHTMLURIEscaper
extends HTMLURIEscaper {
    private HashSet urlTable;

    private synchronized void buildURIAttributeTable() {
        NamePool namePool = this.getPipelineConfiguration().getConfiguration().getNamePool();
        this.urlTable = (HashSet)namePool.getClientData(this.getClass());
        if (this.urlTable == null) {
            this.urlTable = new HashSet(40);
            namePool.setClientData(this.getClass(), this.urlTable);
        }
        this.setUrlAttribute(namePool, "form", "action");
        this.setUrlAttribute(namePool, "object", "archive");
        this.setUrlAttribute(namePool, "body", "background");
        this.setUrlAttribute(namePool, "q", "cite");
        this.setUrlAttribute(namePool, "blockquote", "cite");
        this.setUrlAttribute(namePool, "del", "cite");
        this.setUrlAttribute(namePool, "ins", "cite");
        this.setUrlAttribute(namePool, "object", "classid");
        this.setUrlAttribute(namePool, "object", "codebase");
        this.setUrlAttribute(namePool, "applet", "codebase");
        this.setUrlAttribute(namePool, "object", "data");
        this.setUrlAttribute(namePool, "button", "datasrc");
        this.setUrlAttribute(namePool, "div", "datasrc");
        this.setUrlAttribute(namePool, "input", "datasrc");
        this.setUrlAttribute(namePool, "object", "datasrc");
        this.setUrlAttribute(namePool, "select", "datasrc");
        this.setUrlAttribute(namePool, "span", "datasrc");
        this.setUrlAttribute(namePool, "table", "datasrc");
        this.setUrlAttribute(namePool, "textarea", "datasrc");
        this.setUrlAttribute(namePool, "script", "for");
        this.setUrlAttribute(namePool, "a", "href");
        this.setUrlAttribute(namePool, "a", "name");
        this.setUrlAttribute(namePool, "area", "href");
        this.setUrlAttribute(namePool, "link", "href");
        this.setUrlAttribute(namePool, "base", "href");
        this.setUrlAttribute(namePool, "img", "longdesc");
        this.setUrlAttribute(namePool, "frame", "longdesc");
        this.setUrlAttribute(namePool, "iframe", "longdesc");
        this.setUrlAttribute(namePool, "head", "profile");
        this.setUrlAttribute(namePool, "script", "src");
        this.setUrlAttribute(namePool, "input", "src");
        this.setUrlAttribute(namePool, "frame", "src");
        this.setUrlAttribute(namePool, "iframe", "src");
        this.setUrlAttribute(namePool, "img", "src");
        this.setUrlAttribute(namePool, "img", "usemap");
        this.setUrlAttribute(namePool, "input", "usemap");
        this.setUrlAttribute(namePool, "object", "usemap");
    }

    private void setUrlAttribute(NamePool namePool, String string, String string2) {
        int n = namePool.allocate("", "http://www.w3.org/1999/xhtml", string) & 0xFFFFF;
        int n2 = namePool.allocate("", "", string2) & 0xFFFFF;
        Long l = new Long((long)n << 32 | (long)n2);
        this.urlTable.add(l);
    }

    private boolean isURLAttribute(int n, int n2) {
        Long l = new Long((long)(n &= 0xFFFFF) << 32 | (long)(n2 &= 0xFFFFF));
        return this.urlTable.contains(l);
    }

    public void open() throws XPathException {
        super.open();
        if (this.escapeURIAttributes) {
            this.buildURIAttributeTable();
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.escapeURIAttributes && this.isURLAttribute(this.currentElement, n) && (n4 & 1) == 0) {
            CharSequence charSequence2 = new Normalizer(2).normalize(charSequence);
            this.getUnderlyingReceiver().attribute(n, n2, HTMLURIEscaper.escapeURL(charSequence2), n3, n4 | 2);
        } else {
            this.getUnderlyingReceiver().attribute(n, n2, charSequence, n3, n4);
        }
    }
}

