/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess;

import io.github.spannm.jackcess.DateTimeType;
import io.github.spannm.jackcess.PropertyMap;
import io.github.spannm.jackcess.Relationship;
import io.github.spannm.jackcess.Table;
import io.github.spannm.jackcess.TableMetaData;
import io.github.spannm.jackcess.expr.EvalConfig;
import io.github.spannm.jackcess.impl.DatabaseImpl;
import io.github.spannm.jackcess.query.Query;
import io.github.spannm.jackcess.util.ColumnValidatorFactory;
import io.github.spannm.jackcess.util.ErrorHandler;
import io.github.spannm.jackcess.util.LinkResolver;
import io.github.spannm.jackcess.util.TableIterableBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Database
extends Iterable<Table>,
Closeable,
Flushable {
    public static final boolean DEFAULT_AUTO_SYNC = true;
    public static final Table.ColumnOrder DEFAULT_COLUMN_ORDER = Table.ColumnOrder.DATA;
    public static final String TIMEZONE_PROPERTY = "jackcess.timeZone";
    public static final String CHARSET_PROPERTY_PREFIX = "jackcess.charset.";
    public static final String RESOURCE_PATH_PROPERTY = "jackcess.resourcePath";
    public static final String BROKEN_NIO_PROPERTY = "jackcess.brokenNio";
    public static final String COLUMN_ORDER_PROPERTY = "jackcess.columnOrder";
    public static final String FK_ENFORCE_PROPERTY = "jackcess.enforceForeignKeys";
    public static final String ALLOW_AUTONUM_INSERT_PROPERTY = "jackcess.allowAutoNumberInsert";
    public static final String ENABLE_EXPRESSION_EVALUATION_PROPERTY = "jackcess.enableExpressionEvaluation";
    public static final String DATE_TIME_TYPE_PROPERTY = "jackcess.dateTimeType";
    public static final String FILE_EXT_MDB = ".mdb";
    public static final String FILE_EXT_ACCDB = ".accdb";

    public File getFile();

    public Path getPath();

    public Set<String> getTableNames() throws IOException;

    public Set<String> getSystemTableNames() throws IOException;

    @Override
    public Iterator<Table> iterator();

    default public Stream<Table> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public TableIterableBuilder newIterable();

    public Iterable<TableMetaData> newTableMetaDataIterable();

    default public Stream<TableMetaData> newTableMetaDataStream() {
        return StreamSupport.stream(this.newTableMetaDataIterable().spliterator(), false);
    }

    public Table getTable(String var1) throws IOException;

    public TableMetaData getTableMetaData(String var1) throws IOException;

    public List<Relationship> getRelationships(Table var1, Table var2) throws IOException;

    public List<Relationship> getRelationships(Table var1) throws IOException;

    public List<Relationship> getRelationships() throws IOException;

    public List<Relationship> getSystemRelationships() throws IOException;

    public List<Query> getQueries() throws IOException;

    public Table getSystemTable(String var1) throws IOException;

    public PropertyMap getDatabaseProperties() throws IOException;

    public PropertyMap getSummaryProperties() throws IOException;

    public PropertyMap getUserDefinedProperties() throws IOException;

    public String getDatabasePassword() throws IOException;

    public void createLinkedTable(String var1, String var2, String var3) throws IOException;

    @Override
    public void flush() throws IOException;

    @Override
    public void close() throws IOException;

    public ErrorHandler getErrorHandler();

    public void setErrorHandler(ErrorHandler var1);

    public LinkResolver getLinkResolver();

    public void setLinkResolver(LinkResolver var1);

    public Map<String, Database> getLinkedDatabases();

    public boolean isLinkedTable(Table var1) throws IOException;

    public TimeZone getTimeZone();

    public void setTimeZone(TimeZone var1);

    public ZoneId getZoneId();

    public void setZoneId(ZoneId var1);

    public Charset getCharset();

    public void setCharset(Charset var1);

    public Table.ColumnOrder getColumnOrder();

    public void setColumnOrder(Table.ColumnOrder var1);

    public boolean isEnforceForeignKeys();

    public void setEnforceForeignKeys(Boolean var1);

    public boolean isAllowAutoNumberInsert();

    public void setAllowAutoNumberInsert(Boolean var1);

    public boolean isEvaluateExpressions();

    public void setEvaluateExpressions(Boolean var1);

    public ColumnValidatorFactory getColumnValidatorFactory();

    public void setColumnValidatorFactory(ColumnValidatorFactory var1);

    public FileFormat getFileFormat() throws IOException;

    public EvalConfig getEvalConfig();

    public DateTimeType getDateTimeType();

    public void setDateTimeType(DateTimeType var1);

    public static enum FileFormat {
        V1997(".mdb"),
        GENERIC_JET4(".mdb"),
        V2000(".mdb"),
        V2003(".mdb"),
        V2007(".accdb"),
        V2010(".accdb"),
        V2016(".accdb"),
        V2019(".accdb"),
        MSISAM(".mny");

        private final String ext;

        private FileFormat(String _ext) {
            this.ext = _ext;
        }

        public String getFileExtension() {
            return this.ext;
        }

        public String toString() {
            return this.name() + " [" + DatabaseImpl.getFileFormatDetails(this).getFormat() + "]";
        }

        public static FileFormat parse(String _str) {
            return Arrays.stream(FileFormat.values()).filter(e -> _str != null).filter(e -> e.name().equalsIgnoreCase(_str)).findFirst().orElse(null);
        }
    }
}

