/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.mistralai.DefaultMistralAiHelper;
import dev.langchain4j.model.mistralai.MistralAiChatCompletionRequest;
import dev.langchain4j.model.mistralai.MistralAiChatModelName;
import dev.langchain4j.model.mistralai.MistralAiClient;
import dev.langchain4j.model.mistralai.MistralAiResponseFormatType;
import dev.langchain4j.model.mistralai.MistralAiToolChoiceName;
import dev.langchain4j.model.mistralai.spi.MistralAiStreamingChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MistralAiStreamingChatModel
implements StreamingChatLanguageModel {
    private final MistralAiClient client;
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final Integer maxTokens;
    private final Boolean safePrompt;
    private final Integer randomSeed;
    private final String responseFormat;

    public MistralAiStreamingChatModel(String baseUrl, String apiKey, String modelName, Double temperature, Double topP, Integer maxTokens, Boolean safePrompt, Integer randomSeed, String responseFormat, Boolean logRequests, Boolean logResponses, Duration timeout) {
        this.client = ((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)MistralAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.mistral.ai/v1"))).apiKey(apiKey)).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L)))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)MistralAiChatModelName.OPEN_MISTRAL_7B.toString());
        this.temperature = temperature;
        this.topP = topP;
        this.maxTokens = maxTokens;
        this.safePrompt = safePrompt;
        this.randomSeed = randomSeed;
        this.responseFormat = responseFormat;
    }

    public static MistralAiStreamingChatModel withApiKey(String apiKey) {
        return MistralAiStreamingChatModel.builder().apiKey(apiKey).build();
    }

    public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, toolSpecifications, null, handler);
    }

    public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, null, toolSpecification, handler);
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, null, null, handler);
    }

    private void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted, StreamingResponseHandler<AiMessage> handler) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        MistralAiChatCompletionRequest.MistralAiChatCompletionRequestBuilder requestBuilder = MistralAiChatCompletionRequest.builder().model(this.modelName).messages(DefaultMistralAiHelper.toMistralAiMessages(messages)).temperature(this.temperature).maxTokens(this.maxTokens).topP(this.topP).randomSeed(this.randomSeed).safePrompt(this.safePrompt).stream(true).responseFormat(DefaultMistralAiHelper.toMistralAiResponseFormat(this.responseFormat));
        if (!Utils.isNullOrEmpty(toolSpecifications)) {
            requestBuilder.tools(DefaultMistralAiHelper.toMistralAiTools(toolSpecifications));
            requestBuilder.toolChoice(MistralAiToolChoiceName.AUTO);
        } else if (toolThatMustBeExecuted != null) {
            requestBuilder.tools(DefaultMistralAiHelper.toMistralAiTools(Collections.singletonList(toolThatMustBeExecuted)));
            requestBuilder.toolChoice(MistralAiToolChoiceName.ANY);
        }
        MistralAiChatCompletionRequest request = requestBuilder.build();
        this.client.streamingChatCompletion(request, handler);
    }

    public static MistralAiStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(MistralAiStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            MistralAiStreamingChatModelBuilderFactory factory = (MistralAiStreamingChatModelBuilderFactory)iterator.next();
            return (MistralAiStreamingChatModelBuilder)factory.get();
        }
        return new MistralAiStreamingChatModelBuilder();
    }

    public static class MistralAiStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer maxTokens;
        private Boolean safePrompt;
        private Integer randomSeed;
        private String responseFormat;
        private Boolean logRequests;
        private Boolean logResponses;
        private Duration timeout;

        public MistralAiStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public MistralAiStreamingChatModelBuilder modelName(MistralAiChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public MistralAiStreamingChatModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public MistralAiStreamingChatModelBuilder responseFormat(MistralAiResponseFormatType responseFormat) {
            this.responseFormat = responseFormat.toString();
            return this;
        }

        public MistralAiStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public MistralAiStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public MistralAiStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public MistralAiStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public MistralAiStreamingChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public MistralAiStreamingChatModelBuilder safePrompt(Boolean safePrompt) {
            this.safePrompt = safePrompt;
            return this;
        }

        public MistralAiStreamingChatModelBuilder randomSeed(Integer randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public MistralAiStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public MistralAiStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public MistralAiStreamingChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public MistralAiStreamingChatModel build() {
            return new MistralAiStreamingChatModel(this.baseUrl, this.apiKey, this.modelName, this.temperature, this.topP, this.maxTokens, this.safePrompt, this.randomSeed, this.responseFormat, this.logRequests, this.logResponses, this.timeout);
        }

        public String toString() {
            return "MistralAiStreamingChatModel.MistralAiStreamingChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", topP=" + this.topP + ", maxTokens=" + this.maxTokens + ", safePrompt=" + this.safePrompt + ", randomSeed=" + this.randomSeed + ", responseFormat=" + this.responseFormat + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", timeout=" + this.timeout + ")";
        }
    }
}

