/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.user;

import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;
import org.apache.guacamole.rest.user.APIUser;
import org.apache.guacamole.rest.user.APIUserWrapper;

public class UserObjectTranslator
extends DirectoryObjectTranslator<User, APIUser> {
    public APIUser toExternalObject(User object) throws GuacamoleException {
        return new APIUser(object);
    }

    public User toInternalObject(APIUser object) throws GuacamoleException {
        return new APIUserWrapper(object);
    }

    public void applyExternalChanges(User existingObject, APIUser object) throws GuacamoleException {
        if (object.getPassword() != null) {
            existingObject.setPassword(object.getPassword());
        }
        existingObject.setDisabled(object.isDisabled());
        existingObject.setAttributes(object.getAttributes());
    }

    public void filterExternalObject(UserContext userContext, APIUser object) throws GuacamoleException {
        if (object.getUsername().equals(userContext.self().getIdentifier())) {
            object.setAttributes(this.filterAttributes(userContext.getUserPreferenceAttributes(), object.getAttributes()));
        } else {
            object.setAttributes(this.filterAttributes(userContext.getUserAttributes(), object.getAttributes()));
        }
    }
}

