/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.connectiongroup;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.rest.connectiongroup.APIConnectionGroup;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectResourceFactory;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;
import org.apache.guacamole.rest.directory.DirectoryResource;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectionGroupDirectoryResource
extends DirectoryResource<ConnectionGroup, APIConnectionGroup> {
    @AssistedInject
    public ConnectionGroupDirectoryResource(@Assisted AuthenticatedUser authenticatedUser, @Assisted UserContext userContext, @Assisted Directory<ConnectionGroup> directory, DirectoryObjectTranslator<ConnectionGroup, APIConnectionGroup> translator, DirectoryObjectResourceFactory<ConnectionGroup, APIConnectionGroup> resourceFactory) {
        super(authenticatedUser, userContext, ConnectionGroup.class, directory, translator, resourceFactory);
    }

    public DirectoryObjectResource<ConnectionGroup, APIConnectionGroup> getObjectResource(String identifier) throws GuacamoleException {
        UserContext userContext = this.getUserContext();
        if (identifier != null && identifier.equals("ROOT")) {
            return this.getResourceFactory().create(this.getAuthenticatedUser(), userContext, this.getDirectory(), (Identifiable)userContext.getRootConnectionGroup());
        }
        return super.getObjectResource(identifier);
    }

    protected ObjectPermissionSet getObjectPermissions(Permissions permissions) throws GuacamoleException {
        return permissions.getConnectionGroupPermissions();
    }
}

