/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.extension;

import com.google.inject.Provides;
import com.google.inject.servlet.ServletModule;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.file.FileAuthenticationProvider;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.extension.AuthenticationProviderFacade;
import org.apache.guacamole.extension.DirectoryClassLoader;
import org.apache.guacamole.extension.Extension;
import org.apache.guacamole.extension.ExtensionOrderProperty;
import org.apache.guacamole.extension.LanguageResourceService;
import org.apache.guacamole.extension.ListenerFactory;
import org.apache.guacamole.extension.PatchResourceService;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.event.listener.Listener;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.StringSetProperty;
import org.apache.guacamole.resource.Resource;
import org.apache.guacamole.resource.ResourceServlet;
import org.apache.guacamole.resource.SequenceResource;
import org.apache.guacamole.resource.WebApplicationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionModule
extends ServletModule {
    private final Logger logger = LoggerFactory.getLogger(ExtensionModule.class);
    private static final List<String> ALLOWED_GUACAMOLE_VERSIONS = Collections.unmodifiableList(Arrays.asList("*", "1.0.0", "1.1.0", "1.2.0", "1.3.0", "1.4.0", "1.5.0", "1.5.1", "1.5.2", "1.5.3", "1.5.4"));
    private static final String LIB_DIRECTORY = "lib";
    private static final String EXTENSIONS_DIRECTORY = "extensions";
    private static final String EXTENSION_SUFFIX = ".jar";
    public static final StringSetProperty SKIP_IF_UNAVAILABLE = new /* Unavailable Anonymous Inner Class!! */;
    public static final ExtensionOrderProperty EXTENSION_PRIORITY = new /* Unavailable Anonymous Inner Class!! */;
    private final Environment environment;
    private final List<AuthenticationProvider> boundAuthenticationProviders = new ArrayList();
    private final List<Listener> boundListeners = new ArrayList();
    private final List<File> temporaryFiles = new ArrayList();
    private final LanguageResourceService languageResourceService;
    private final PatchResourceService patchResourceService;

    private ClassLoader getParentClassLoader() throws GuacamoleException {
        File libDir = new File(this.environment.getGuacamoleHome(), LIB_DIRECTORY);
        if (!libDir.isDirectory()) {
            return ExtensionModule.class.getClassLoader();
        }
        return DirectoryClassLoader.getInstance((File)libDir);
    }

    public ExtensionModule(Environment environment) {
        this.environment = environment;
        this.languageResourceService = new LanguageResourceService(environment);
        this.patchResourceService = new PatchResourceService();
    }

    private void bindAuthenticationProvider(Class<? extends AuthenticationProvider> authenticationProvider, Set<String> tolerateFailures) {
        this.logger.debug("[{}] Binding AuthenticationProvider \"{}\".", (Object)this.boundAuthenticationProviders.size(), (Object)authenticationProvider.getName());
        this.boundAuthenticationProviders.add(new AuthenticationProviderFacade(authenticationProvider, tolerateFailures));
    }

    private void bindAuthenticationProviders(Collection<Class<AuthenticationProvider>> authProviders, Set<String> tolerateFailures) {
        for (Class<AuthenticationProvider> authenticationProvider : authProviders) {
            this.bindAuthenticationProvider(authenticationProvider, tolerateFailures);
        }
    }

    @Provides
    public List<AuthenticationProvider> getAuthenticationProviders() {
        return Collections.unmodifiableList(this.boundAuthenticationProviders);
    }

    @Provides
    public List<File> getTemporaryFiles() {
        return Collections.unmodifiableList(this.temporaryFiles);
    }

    private void bindListener(Class<?> providerClass) {
        this.logger.debug("[{}] Binding listener \"{}\".", (Object)this.boundListeners.size(), (Object)providerClass.getName());
        this.boundListeners.addAll(ListenerFactory.createListeners(providerClass));
    }

    private void bindListeners(Collection<Class<?>> listeners) {
        for (Class<?> listener : listeners) {
            this.bindListener(listener);
        }
    }

    @Provides
    public List<Listener> getListeners() {
        return Collections.unmodifiableList(this.boundListeners);
    }

    private void serveLanguageResources(Map<String, Resource> resources) {
        for (Map.Entry<String, Resource> translationResource : resources.entrySet()) {
            String path = translationResource.getKey();
            Resource resource = translationResource.getValue();
            String languageKey = this.languageResourceService.getLanguageKey(path);
            if (languageKey == null) {
                this.logger.warn("Invalid language file name: \"{}\"", (Object)path);
                continue;
            }
            this.languageResourceService.addLanguageResource(languageKey, resource);
        }
    }

    private void serveStaticResources(String prefix, Map<String, Resource> resources) {
        for (Map.Entry<String, Resource> staticResource : resources.entrySet()) {
            String path = staticResource.getKey();
            Resource resource = staticResource.getValue();
            this.serve(prefix + path, new String[0]).with((HttpServlet)new ResourceServlet(resource));
        }
    }

    private boolean isCompatible(String guacamoleVersion) {
        return ALLOWED_GUACAMOLE_VERSIONS.contains(guacamoleVersion);
    }

    private Set<String> getToleratedAuthenticationProviders() {
        try {
            return (Set)this.environment.getProperty((GuacamoleProperty)SKIP_IF_UNAVAILABLE, Collections.emptySet());
        }
        catch (GuacamoleException e) {
            this.logger.warn("The list of authentication providers specified via the \"{}\" property could not be parsed: {}", (Object)SKIP_IF_UNAVAILABLE.getName(), (Object)e.getMessage());
            this.logger.debug("Unable to parse \"{}\" property.", (Object)SKIP_IF_UNAVAILABLE.getName(), (Object)e);
            return Collections.emptySet();
        }
    }

    private Comparator<Extension> getExtensionLoadOrder() {
        try {
            return (Comparator)this.environment.getProperty((GuacamoleProperty)EXTENSION_PRIORITY, (Object)ExtensionOrderProperty.DEFAULT_COMPARATOR);
        }
        catch (GuacamoleException e) {
            this.logger.warn("The list of extensions specified via the \"{}\" property could not be parsed: {}", (Object)EXTENSION_PRIORITY.getName(), (Object)e.getMessage());
            this.logger.debug("Unable to parse \"{}\" property.", (Object)EXTENSION_PRIORITY.getName(), (Object)e);
            return ExtensionOrderProperty.DEFAULT_COMPARATOR;
        }
    }

    private List<Extension> getExtensions() {
        File extensionsDir = new File(this.environment.getGuacamoleHome(), EXTENSIONS_DIRECTORY);
        if (!extensionsDir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] extensionFiles = extensionsDir.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (extensionFiles == null) {
            this.logger.warn("Although GUACAMOLE_HOME/extensions exists, its contents cannot be read.");
            return Collections.emptyList();
        }
        ArrayList<Extension> extensions = new ArrayList<Extension>(extensionFiles.length);
        for (File extensionFile : extensionFiles) {
            this.logger.debug("Reading extension: \"{}\"", (Object)extensionFile.getName());
            try {
                Extension extension = new Extension(this.getParentClassLoader(), extensionFile, this.temporaryFiles);
                if (!this.isCompatible(extension.getGuacamoleVersion())) {
                    this.logger.debug("Declared Guacamole version \"{}\" of extension \"{}\" is not compatible with this version of Guacamole.", (Object)extension.getGuacamoleVersion(), (Object)extensionFile.getName());
                    throw new GuacamoleServerException("Extension \"" + extension.getName() + "\" is not compatible with this version of Guacamole.");
                }
                extensions.add(extension);
            }
            catch (GuacamoleException e) {
                this.logger.error("Extension \"{}\" could not be loaded: {}", (Object)extensionFile.getName(), (Object)e.getMessage());
                this.logger.debug("Unable to load extension.", (Throwable)e);
            }
        }
        extensions.sort(this.getExtensionLoadOrder());
        return extensions;
    }

    private void loadExtensions(Collection<Resource> javaScriptResources, Collection<Resource> cssResources, Set<String> toleratedAuthProviders) {
        List extensions = this.getExtensions();
        if (extensions.size() > 1) {
            this.logger.info("Multiple extensions are installed and will be loaded in order of decreasing priority:");
            for (Extension extension : extensions) {
                this.logger.info(" - [{}] \"{}\" ({})", new Object[]{extension.getNamespace(), extension.getName(), extension.getFile()});
            }
            this.logger.info("To change this order, set the \"{}\" property or rename the extension files. The default priority of extensions is dictated by the sort order of their filenames.", (Object)EXTENSION_PRIORITY.getName());
        }
        for (Extension extension : extensions) {
            javaScriptResources.addAll(extension.getJavaScriptResources().values());
            cssResources.addAll(extension.getCSSResources().values());
            this.bindAuthenticationProviders(extension.getAuthenticationProviderClasses(), toleratedAuthProviders);
            this.bindListeners(extension.getListenerClasses());
            this.serveLanguageResources(extension.getTranslationResources());
            this.patchResourceService.addPatchResources(extension.getHTMLResources().values());
            String staticResourcePrefix = "/app/ext/" + extension.getNamespace() + "/";
            this.serveStaticResources(staticResourcePrefix, extension.getStaticResources());
            if (extension.getSmallIcon() != null) {
                this.serve("/images/logo-64.png", new String[0]).with((HttpServlet)new ResourceServlet(extension.getSmallIcon()));
            }
            if (extension.getLargeIcon() != null) {
                this.serve("/images/logo-144.png", new String[0]).with((HttpServlet)new ResourceServlet(extension.getLargeIcon()));
            }
            this.logger.info("Extension \"{}\" ({}) loaded.", (Object)extension.getName(), (Object)extension.getNamespace());
        }
    }

    protected void configureServlets() {
        this.bind(LanguageResourceService.class).toInstance((Object)this.languageResourceService);
        this.bind(PatchResourceService.class).toInstance((Object)this.patchResourceService);
        this.languageResourceService.addLanguageResources(this.getServletContext());
        ArrayList<WebApplicationResource> javaScriptResources = new ArrayList<WebApplicationResource>();
        ArrayList cssResources = new ArrayList();
        javaScriptResources.add(new WebApplicationResource(this.getServletContext(), "/verifyCachedVersion.js"));
        Set toleratedAuthProviders = this.getToleratedAuthenticationProviders();
        this.loadExtensions(javaScriptResources, cssResources, toleratedAuthProviders);
        this.bindAuthenticationProvider(FileAuthenticationProvider.class, toleratedAuthProviders);
        this.serve("/app.js", new String[0]).with((HttpServlet)new ResourceServlet((Resource)new SequenceResource(javaScriptResources)));
        this.serve("/app.css", new String[0]).with((HttpServlet)new ResourceServlet((Resource)new SequenceResource(cssResources)));
        for (Map.Entry entry : this.languageResourceService.getLanguageResources().entrySet()) {
            String languageKey = (String)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            this.serve("/translations/" + languageKey + ".json", new String[0]).with((HttpServlet)new ResourceServlet(resource));
        }
    }
}

