/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor.impl;

import groovy.lang.GroovyRuntimeException;
import groovy.time.BaseDuration;
import groovyx.gpars.actor.Actor;
import groovyx.gpars.actor.ActorMessage;
import groovyx.gpars.actor.Actors;
import groovyx.gpars.actor.impl.ActorException;
import groovyx.gpars.actor.impl.ActorStopException;
import groovyx.gpars.actor.impl.ActorTerminationException;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.actor.impl.ReplyingMessageStream;
import groovyx.gpars.group.PGroup;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public abstract class SequentialProcessingActor
extends ReplyingMessageStream
implements Runnable {
    private static final long serialVersionUID = 6479220959200502418L;
    private volatile Node inputQueue;
    private Node outputQueue;
    private final AtomicBoolean ongoingThreadTermination = new AtomicBoolean(false);
    private static final AtomicReferenceFieldUpdater<SequentialProcessingActor, Node> inputQueueUpdater = AtomicReferenceFieldUpdater.newUpdater(SequentialProcessingActor.class, Node.class, "inputQueue");
    private volatile Thread waitingThread;
    protected static final int S_ACTIVE_MASK = 1;
    protected static final int S_FINISHING_MASK = 2;
    protected static final int S_FINISHED_MASK = 4;
    protected static final int S_STOP_TERMINATE_MASK = 8;
    protected static final int S_NOT_STARTED = 0;
    protected static final int S_RUNNING = 1;
    protected static final int S_STOPPING = 11;
    protected static final int S_TERMINATING = 3;
    protected static final int S_STOPPED = 12;
    protected static final int S_TERMINATED = 4;
    protected volatile int stopFlag = 0;
    protected static final AtomicIntegerFieldUpdater<SequentialProcessingActor> stopFlagUpdater = AtomicIntegerFieldUpdater.newUpdater(SequentialProcessingActor.class, "stopFlag");
    private static final String SHOULD_NOT_REACH_HERE = "Should not reach here";

    @Override
    public final boolean isActive() {
        return (this.stopFlag & 1) != 0;
    }

    private void throwIfNeeded(ActorMessage toProcess) {
        if (toProcess == STOP_MESSAGE) {
            this.stopFlag = 11;
            throw ActorException.STOP;
        }
        if (toProcess == TERMINATE_MESSAGE) {
            this.stopFlag = 3;
            throw ActorException.TERMINATE;
        }
    }

    protected final ActorMessage pollMessage() {
        assert (this.isActorThread());
        this.transferQueues();
        ActorMessage toProcess = null;
        if (this.outputQueue != null) {
            toProcess = this.outputQueue.msg;
            this.outputQueue = this.outputQueue.next;
        }
        return toProcess;
    }

    protected final ActorMessage takeMessage() throws InterruptedException {
        ActorMessage message;
        assert (this.isActorThread());
        while ((message = this.awaitNextMessage(0L)) == null) {
        }
        return message;
    }

    protected ActorMessage takeMessage(long timeout, TimeUnit timeUnit) throws InterruptedException {
        assert (this.isActorThread());
        long endTime = System.nanoTime() + timeUnit.toNanos(timeout);
        do {
            ActorMessage message;
            if ((message = this.awaitNextMessage(endTime)) == null) continue;
            return message;
        } while (System.nanoTime() < endTime);
        this.handleTimeout();
        return TIMEOUT_MESSAGE;
    }

    private ActorMessage awaitNextMessage(long endTime) throws InterruptedException {
        this.transferQueues();
        this.waitingThread = Thread.currentThread();
        if (this.outputQueue != null) {
            return this.retrieveNextMessage();
        }
        if (endTime == 0L) {
            LockSupport.park();
        } else {
            LockSupport.parkNanos(endTime - System.nanoTime());
        }
        MessageStream.reInterrupt();
        return null;
    }

    private ActorMessage retrieveNextMessage() {
        ActorMessage toProcess = this.outputQueue.msg;
        this.outputQueue = this.outputQueue.next;
        this.throwIfNeeded(toProcess);
        return toProcess;
    }

    private void transferQueues() {
        if (this.outputQueue == null) {
            Node node = inputQueueUpdater.getAndSet(this, null);
            while (node != null) {
                Node next = node.next;
                node.next = this.outputQueue;
                this.outputQueue = node;
                node = next;
            }
        }
    }

    protected SequentialProcessingActor() {
        this.setParallelGroup(Actors.defaultActorPGroup);
    }

    @Override
    public final void setParallelGroup(PGroup group) {
        if (this.stopFlag != 0) {
            throw new IllegalStateException("Cannot reset actor's group after it was started.");
        }
        super.setParallelGroup(group);
        this.parallelGroup = group;
    }

    @Override
    public final MessageStream send(Object message) {
        block1: {
            Node prev;
            Node toAdd = new Node(this.createActorMessage(message));
            do {
                toAdd.next = prev = this.inputQueue;
            } while (!inputQueueUpdater.compareAndSet(this, prev, toAdd));
            Thread w = this.waitingThread;
            if (w == null) break block1;
            this.waitingThread = null;
            LockSupport.unpark(w);
        }
        return this;
    }

    @Override
    protected final boolean hasBeenStopped() {
        return this.stopFlag != 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleTermination() {
        if (this.stopFlag == 11) {
            this.stopFlag = 12;
        } else if (this.stopFlag == 3) {
            this.stopFlag = 4;
        } else {
            throw new IllegalStateException("Messed up actors state detected when terminating: " + this.stopFlag);
        }
        try {
            super.handleTermination();
        }
        finally {
            this.getJoinLatch().bindUnique(null);
        }
    }

    @Override
    public Actor silentStart() {
        throw new UnsupportedOperationException("Old actors cannot start silently. Use DefaultActor instead.");
    }

    @Override
    public final SequentialProcessingActor start() {
        if (!stopFlagUpdater.compareAndSet(this, 0, 1)) {
            throw new IllegalStateException("Actor has already been started.");
        }
        this.parallelGroup.getThreadPool().execute(this);
        this.send(START_MESSAGE);
        return this;
    }

    @Override
    public final Actor stop() {
        if (stopFlagUpdater.compareAndSet(this, 1, 11)) {
            this.send(STOP_MESSAGE);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Actor terminate() {
        int flag;
        while (((flag = this.stopFlag) & 4) == 0 && flag != 3) {
            if (!stopFlagUpdater.compareAndSet(this, flag, 3)) continue;
            if (this.isActorThread()) {
                throw ActorException.TERMINATE;
            }
            try {
                while (!this.ongoingThreadTermination.compareAndSet(false, true)) {
                    Thread.yield();
                }
                if (this.currentThread != null) {
                    this.currentThread.interrupt();
                    break;
                }
                try {
                    this.send(TERMINATE_MESSAGE);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                break;
            }
            finally {
                this.ongoingThreadTermination.set(false);
            }
        }
        return this;
    }

    protected abstract Object receiveImpl() throws InterruptedException;

    protected abstract Object receiveImpl(long var1, TimeUnit var3) throws InterruptedException;

    protected final Object receive() throws InterruptedException {
        Object msg = this.receiveImpl();
        return SequentialProcessingActor.unwrapMessage(msg);
    }

    protected final Object receive(long timeout, TimeUnit units) throws InterruptedException {
        Object msg = this.receiveImpl(timeout, units);
        return SequentialProcessingActor.unwrapMessage(msg);
    }

    private static Object unwrapMessage(Object msg) {
        if (msg instanceof ActorMessage) {
            return ((ActorMessage)msg).getPayLoad();
        }
        return msg;
    }

    protected final Object receive(BaseDuration duration) throws InterruptedException {
        return this.receive(duration.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected final ActorMessage sweepNextMessage() {
        return this.pollMessage();
    }

    protected abstract void act();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            assert (this.currentThread == null);
            SequentialProcessingActor.registerCurrentActorWithThread(this);
            this.currentThread = Thread.currentThread();
            try {
                if (this.stopFlag == 3) {
                    throw ActorException.TERMINATE;
                }
                ActorMessage toProcess = this.takeMessage();
                if (toProcess == START_MESSAGE) {
                    this.handleStart();
                    this.stopFlag = 11;
                    throw ActorException.STOP;
                }
            }
            catch (GroovyRuntimeException gre) {
                throw ScriptBytecodeAdapter.unwrap((GroovyRuntimeException)gre);
            }
        }
        catch (ActorTerminationException ignore) {
            try {
                while (!this.ongoingThreadTermination.compareAndSet(false, true)) {
                    Thread.yield();
                }
                Thread.interrupted();
                this.handleTermination();
            }
            finally {
                SequentialProcessingActor.deregisterCurrentActorWithThread();
                this.currentThread = null;
                this.ongoingThreadTermination.set(false);
            }
        }
        catch (ActorStopException termination) {
            assert (this.stopFlag != 12);
            assert (this.stopFlag != 4);
        }
        catch (InterruptedException e) {
            assert (this.stopFlag != 12);
            assert (this.stopFlag != 4);
            this.stopFlag = 3;
            this.handleInterrupt(e);
        }
        catch (Throwable e) {
            assert (this.stopFlag != 12);
            assert (this.stopFlag != 4);
            this.stopFlag = 3;
            this.handleException(e);
        }
        finally {
            try {
                while (!this.ongoingThreadTermination.compareAndSet(false, true)) {
                    Thread.yield();
                }
                Thread.interrupted();
                this.handleTermination();
            }
            finally {
                SequentialProcessingActor.deregisterCurrentActorWithThread();
                this.currentThread = null;
                this.ongoingThreadTermination.set(false);
            }
        }
    }

    protected final void checkStopTerminate() {
        if (this.hasBeenStopped()) {
            if (this.stopFlag == 3) {
                throw ActorException.TERMINATE;
            }
            if (this.stopFlag != 11) {
                throw new IllegalStateException(SHOULD_NOT_REACH_HERE);
            }
        }
    }

    private static class Node {
        volatile Node next;
        final ActorMessage msg;

        Node(ActorMessage actorMessage) {
            this.msg = actorMessage;
        }
    }
}

