/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source.snapshot;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.DataTable;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.snapshot.CompactedStartingScanner;
import org.apache.flink.table.store.table.source.snapshot.FullStartingScanner;
import org.apache.flink.table.store.table.source.snapshot.SnapshotEnumerator;
import org.apache.flink.table.store.table.source.snapshot.StartingScanner;
import org.apache.flink.table.store.table.source.snapshot.StaticFromSnapshotStartingScanner;
import org.apache.flink.table.store.table.source.snapshot.StaticFromTimestampStartingScanner;
import org.apache.flink.util.Preconditions;

public class StaticDataFileSnapshotEnumerator
implements SnapshotEnumerator {
    private final SnapshotManager snapshotManager;
    private final DataTableScan scan;
    private final StartingScanner startingScanner;
    private boolean hasNext;

    public StaticDataFileSnapshotEnumerator(Path tablePath, DataTableScan scan, StartingScanner startingScanner) {
        this.snapshotManager = new SnapshotManager(tablePath);
        this.scan = scan;
        this.startingScanner = startingScanner;
        this.hasNext = true;
    }

    @Override
    @Nullable
    public DataTableScan.DataFilePlan enumerate() {
        if (this.hasNext) {
            this.hasNext = false;
            return this.startingScanner.getPlan(this.snapshotManager, this.scan);
        }
        return null;
    }

    public static StaticDataFileSnapshotEnumerator create(DataTable table, DataTableScan scan) {
        StartingScanner startingScanner;
        CoreOptions.StartupMode startupMode = table.options().startupMode();
        if (startupMode == CoreOptions.StartupMode.LATEST_FULL || startupMode == CoreOptions.StartupMode.LATEST) {
            startingScanner = new FullStartingScanner();
        } else if (startupMode == CoreOptions.StartupMode.COMPACTED_FULL) {
            startingScanner = new CompactedStartingScanner();
        } else if (startupMode == CoreOptions.StartupMode.FROM_TIMESTAMP) {
            Long startupMillis = table.options().scanTimestampMills();
            Preconditions.checkNotNull(startupMillis, String.format("%s can not be null when you use %s for %s", CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), CoreOptions.StartupMode.FROM_TIMESTAMP, CoreOptions.SCAN_MODE.key()));
            startingScanner = new StaticFromTimestampStartingScanner(startupMillis);
        } else if (startupMode == CoreOptions.StartupMode.FROM_SNAPSHOT) {
            Long snapshotId = table.options().scanSnapshotId();
            Preconditions.checkNotNull(snapshotId, String.format("%s can not be null when you use %s for %s", CoreOptions.SCAN_SNAPSHOT_ID.key(), CoreOptions.StartupMode.FROM_SNAPSHOT, CoreOptions.SCAN_MODE.key()));
            startingScanner = new StaticFromSnapshotStartingScanner(snapshotId);
        } else {
            throw new UnsupportedOperationException("Unknown startup mode " + startupMode.name());
        }
        return new StaticDataFileSnapshotEnumerator(table.location(), scan, startingScanner);
    }

    public static interface Factory
    extends Serializable {
        public StaticDataFileSnapshotEnumerator create(DataTable var1, DataTableScan var2);
    }
}

