/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact.aggregate;

import java.io.Serializable;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldBoolAndAgg;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldBoolOrAgg;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldLastNonNullValueAgg;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldLastValueAgg;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldListaggAgg;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldMaxAgg;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldMinAgg;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldSumAgg;
import org.apache.flink.table.types.logical.LogicalType;

public abstract class FieldAggregator
implements Serializable {
    protected LogicalType fieldType;

    public FieldAggregator(LogicalType logicalType) {
        this.fieldType = logicalType;
    }

    static FieldAggregator createFieldAggregator(LogicalType fieldType, String strAgg, boolean isPrimaryKey) {
        FieldAggregator fieldAggregator;
        if (isPrimaryKey) {
            fieldAggregator = new FieldLastValueAgg(fieldType);
        } else {
            switch (strAgg) {
                case "sum": {
                    fieldAggregator = new FieldSumAgg(fieldType);
                    break;
                }
                case "max": {
                    fieldAggregator = new FieldMaxAgg(fieldType);
                    break;
                }
                case "min": {
                    fieldAggregator = new FieldMinAgg(fieldType);
                    break;
                }
                case "last_non_null_value": {
                    fieldAggregator = new FieldLastNonNullValueAgg(fieldType);
                    break;
                }
                case "last_value": {
                    fieldAggregator = new FieldLastValueAgg(fieldType);
                    break;
                }
                case "listagg": {
                    fieldAggregator = new FieldListaggAgg(fieldType);
                    break;
                }
                case "bool_or": {
                    fieldAggregator = new FieldBoolOrAgg(fieldType);
                    break;
                }
                case "bool_and": {
                    fieldAggregator = new FieldBoolAndAgg(fieldType);
                    break;
                }
                default: {
                    throw new ValidationException("Use unsupported aggregation or spell aggregate function incorrectly!");
                }
            }
        }
        return fieldAggregator;
    }

    abstract Object agg(Object var1, Object var2);
}

