/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import javax.annotation.Nullable;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunction;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunctionFactory;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class ValueCountMergeFunction
implements MergeFunction<KeyValue> {
    private KeyValue latestKv;
    private long total;
    private KeyValue reused;

    protected ValueCountMergeFunction() {
    }

    @Override
    public void reset() {
        this.latestKv = null;
        this.total = 0L;
    }

    @Override
    public void add(KeyValue kv) {
        Preconditions.checkArgument(kv.valueKind() == RowKind.INSERT, "In value count mode, only insert records come. This is a bug. Please file an issue.");
        this.latestKv = kv;
        this.total += this.count(kv.value());
    }

    @Override
    @Nullable
    public KeyValue getResult() {
        if (this.total == 0L) {
            return null;
        }
        if (this.reused == null) {
            this.reused = new KeyValue();
        }
        return this.reused.replace(this.latestKv.key(), this.latestKv.sequenceNumber(), RowKind.INSERT, GenericRowData.of(this.total));
    }

    private long count(RowData value) {
        Preconditions.checkArgument(!value.isNullAt(0), "Value count should not be null.");
        return value.getLong(0);
    }

    public static MergeFunctionFactory<KeyValue> factory() {
        return new Factory();
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;

        private Factory() {
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            return new ValueCountMergeFunction();
        }
    }
}

