/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataview;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.dataview.NullAwareMapSerializerSnapshot;

@Deprecated
@Internal
public class NullAwareMapSerializer<K, V>
extends TypeSerializer<Map<K, V>> {
    private static final long serialVersionUID = 5363147328373166590L;
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<V> valueSerializer;

    public NullAwareMapSerializer(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<Map<K, V>> duplicate() {
        return new NullAwareMapSerializer<K, V>(this.keySerializer.duplicate(), this.valueSerializer.duplicate());
    }

    @Override
    public Map<K, V> createInstance() {
        return new HashMap();
    }

    @Override
    public Map<K, V> copy(Map<K, V> from) {
        HashMap<Object, Object> newMap = new HashMap<Object, Object>(from.size());
        for (Map.Entry<K, V> entry : from.entrySet()) {
            Object newKey = entry.getKey() == null ? null : (Object)this.keySerializer.copy(entry.getKey());
            Object newValue = entry.getValue() == null ? null : (Object)this.valueSerializer.copy(entry.getValue());
            newMap.put(newKey, newValue);
        }
        return newMap;
    }

    @Override
    public Map<K, V> copy(Map<K, V> from, Map<K, V> reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(Map<K, V> map, DataOutputView target) throws IOException {
        int size = map.size();
        target.writeInt(size);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                target.writeBoolean(true);
            } else {
                target.writeBoolean(false);
                this.keySerializer.serialize(entry.getKey(), target);
            }
            if (entry.getValue() == null) {
                target.writeBoolean(true);
                continue;
            }
            target.writeBoolean(false);
            this.valueSerializer.serialize(entry.getValue(), target);
        }
    }

    @Override
    public Map<K, V> deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            boolean keyIsNull = source.readBoolean();
            Object key = keyIsNull ? null : (Object)this.keySerializer.deserialize(source);
            boolean valueIsNull = source.readBoolean();
            Object value = valueIsNull ? null : (Object)this.valueSerializer.deserialize(source);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Map<K, V> deserialize(Map<K, V> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int size = source.readInt();
        target.writeInt(size);
        for (int i = 0; i < size; ++i) {
            boolean keyIsNull = source.readBoolean();
            target.writeBoolean(keyIsNull);
            if (!keyIsNull) {
                this.keySerializer.copy(source, target);
            }
            boolean valueIsNull = source.readBoolean();
            target.writeBoolean(valueIsNull);
            if (valueIsNull) continue;
            this.valueSerializer.copy(source, target);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.keySerializer.equals(((NullAwareMapSerializer)obj).getKeySerializer()) && this.valueSerializer.equals(((NullAwareMapSerializer)obj).getValueSerializer());
    }

    @Override
    public int hashCode() {
        return this.keySerializer.hashCode() * 31 + this.valueSerializer.hashCode();
    }

    @Override
    public TypeSerializerSnapshot<Map<K, V>> snapshotConfiguration() {
        return new NullAwareMapSerializerSnapshot(this);
    }
}

