/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.LongValue;

@Internal
public final class LongValueSerializer
extends TypeSerializerSingleton<LongValue> {
    private static final long serialVersionUID = 1L;
    public static final LongValueSerializer INSTANCE = new LongValueSerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public LongValue createInstance() {
        return new LongValue();
    }

    @Override
    public LongValue copy(LongValue from) {
        return this.copy(from, new LongValue());
    }

    @Override
    public LongValue copy(LongValue from, LongValue reuse) {
        reuse.setValue(from.getValue());
        return reuse;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void serialize(LongValue record, DataOutputView target) throws IOException {
        record.write(target);
    }

    @Override
    public LongValue deserialize(DataInputView source) throws IOException {
        return this.deserialize(new LongValue(), source);
    }

    @Override
    public LongValue deserialize(LongValue reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeLong(source.readLong());
    }

    @Override
    public TypeSerializerSnapshot<LongValue> snapshotConfiguration() {
        return new LongValueSerializerSnapshot();
    }

    public static final class LongValueSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<LongValue> {
        public LongValueSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

