/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

public abstract class DataType
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final LogicalType logicalType;

    DataType(LogicalType logicalType) {
        this.logicalType = Preconditions.checkNotNull(logicalType, "Logical type must not be null.");
    }

    public LogicalType logicalType() {
        return this.logicalType;
    }

    public abstract DataType copy(boolean var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataType dataType = (DataType)o;
        return Objects.equals(this.logicalType, dataType.logicalType);
    }

    public int hashCode() {
        return Objects.hash(this.logicalType);
    }
}

