/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterators;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.memory.HeapMemorySegmentPool;
import org.apache.flink.table.store.file.memory.MemoryOwner;
import org.apache.flink.table.store.file.memory.MemoryPoolFactory;
import org.apache.flink.table.store.file.operation.AbstractFileStoreWrite;
import org.apache.flink.table.store.file.operation.FileStoreScan;
import org.apache.flink.table.store.file.utils.RecordWriter;
import org.apache.flink.table.store.file.utils.SnapshotManager;

public abstract class MemoryFileStoreWrite<T>
extends AbstractFileStoreWrite<T> {
    private final MemoryPoolFactory memoryPoolFactory;

    public MemoryFileStoreWrite(String commitUser, SnapshotManager snapshotManager, FileStoreScan scan, CoreOptions options) {
        super(commitUser, snapshotManager, scan);
        HeapMemorySegmentPool memoryPool = new HeapMemorySegmentPool(options.writeBufferSize(), options.pageSize());
        this.memoryPoolFactory = new MemoryPoolFactory(memoryPool, this::memoryOwners);
    }

    private Iterator<MemoryOwner> memoryOwners() {
        final Iterator iterator = this.writers.values().iterator();
        return Iterators.concat(new Iterator<Iterator<MemoryOwner>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Iterator<MemoryOwner> next() {
                return Iterators.transform(((Map)iterator.next()).values().iterator(), writerContainer -> writerContainer == null ? null : (MemoryOwner)((Object)writerContainer.writer));
            }
        });
    }

    @Override
    protected void notifyNewWriter(RecordWriter<T> writer) {
        if (!(writer instanceof MemoryOwner)) {
            throw new RuntimeException("Should create a MemoryOwner for MemoryTableWrite, but this is: " + writer.getClass());
        }
        this.memoryPoolFactory.notifyNewOwner((MemoryOwner)((Object)writer));
    }
}

