/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.operators.TimerHeapInternalTimer;
import org.apache.flink.streaming.api.operators.TimerSerializerSnapshot;
import org.apache.flink.util.MathUtils;

@Internal
public class TimerSerializer<K, N>
extends TypeSerializer<TimerHeapInternalTimer<K, N>> {
    private static final long serialVersionUID = 1L;
    private static final int KEY_SERIALIZER_SNAPSHOT_INDEX = 0;
    private static final int NAMESPACE_SERIALIZER_SNAPSHOT_INDEX = 1;
    @Nonnull
    private final TypeSerializer<K> keySerializer;
    @Nonnull
    private final TypeSerializer<N> namespaceSerializer;
    private final int length;
    private final boolean immutableType;

    public TimerSerializer(@Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<N> namespaceSerializer) {
        this(keySerializer, namespaceSerializer, TimerSerializer.computeTotalByteLength(keySerializer, namespaceSerializer), keySerializer.isImmutableType() && namespaceSerializer.isImmutableType());
    }

    private TimerSerializer(@Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<N> namespaceSerializer, int length, boolean immutableType) {
        this.keySerializer = keySerializer;
        this.namespaceSerializer = namespaceSerializer;
        this.length = length;
        this.immutableType = immutableType;
    }

    private static int computeTotalByteLength(TypeSerializer<?> keySerializer, TypeSerializer<?> namespaceSerializer) {
        if (keySerializer.getLength() >= 0 && namespaceSerializer.getLength() >= 0) {
            return 8 + keySerializer.getLength() + namespaceSerializer.getLength();
        }
        return -1;
    }

    @Override
    public boolean isImmutableType() {
        return this.immutableType;
    }

    public TimerSerializer<K, N> duplicate() {
        TypeSerializer<K> keySerializerDuplicate = this.keySerializer.duplicate();
        TypeSerializer<N> namespaceSerializerDuplicate = this.namespaceSerializer.duplicate();
        if (keySerializerDuplicate == this.keySerializer && namespaceSerializerDuplicate == this.namespaceSerializer) {
            return this;
        }
        return new TimerSerializer<K, N>(keySerializerDuplicate, namespaceSerializerDuplicate, this.length, this.immutableType);
    }

    @Override
    public TimerHeapInternalTimer<K, N> createInstance() {
        return new TimerHeapInternalTimer<K, N>(0L, this.keySerializer.createInstance(), this.namespaceSerializer.createInstance());
    }

    @Override
    public TimerHeapInternalTimer<K, N> copy(TimerHeapInternalTimer<K, N> from) {
        N namespaceDuplicate;
        K keyDuplicate;
        if (this.isImmutableType()) {
            keyDuplicate = from.getKey();
            namespaceDuplicate = from.getNamespace();
        } else {
            keyDuplicate = this.keySerializer.copy(from.getKey());
            namespaceDuplicate = this.namespaceSerializer.copy(from.getNamespace());
        }
        return new TimerHeapInternalTimer<K, N>(from.getTimestamp(), keyDuplicate, namespaceDuplicate);
    }

    @Override
    public TimerHeapInternalTimer<K, N> copy(TimerHeapInternalTimer<K, N> from, TimerHeapInternalTimer<K, N> reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void serialize(TimerHeapInternalTimer<K, N> record, DataOutputView target) throws IOException {
        target.writeLong(MathUtils.flipSignBit(record.getTimestamp()));
        this.keySerializer.serialize(record.getKey(), target);
        this.namespaceSerializer.serialize(record.getNamespace(), target);
    }

    @Override
    public TimerHeapInternalTimer<K, N> deserialize(DataInputView source) throws IOException {
        long timestamp = MathUtils.flipSignBit(source.readLong());
        K key = this.keySerializer.deserialize(source);
        N namespace = this.namespaceSerializer.deserialize(source);
        return new TimerHeapInternalTimer<K, N>(timestamp, key, namespace);
    }

    @Override
    public TimerHeapInternalTimer<K, N> deserialize(TimerHeapInternalTimer<K, N> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeLong(source.readLong());
        this.keySerializer.copy(source, target);
        this.namespaceSerializer.copy(source, target);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimerSerializer that = (TimerSerializer)o;
        return Objects.equals(this.keySerializer, that.keySerializer) && Objects.equals(this.namespaceSerializer, that.namespaceSerializer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keySerializer, this.namespaceSerializer);
    }

    public TimerSerializerSnapshot<K, N> snapshotConfiguration() {
        return new TimerSerializerSnapshot(this);
    }

    @Nonnull
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Nonnull
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    @Deprecated
    public static class TimerSerializerConfigSnapshot<K, N>
    extends CompositeTypeSerializerConfigSnapshot<TimerHeapInternalTimer<K, N>> {
        private static final int VERSION = 1;

        public TimerSerializerConfigSnapshot() {
        }

        public TimerSerializerConfigSnapshot(@Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<N> namespaceSerializer) {
            super(TimerSerializerConfigSnapshot.init(keySerializer, namespaceSerializer));
        }

        private static TypeSerializer<?>[] init(@Nonnull TypeSerializer<?> keySerializer, @Nonnull TypeSerializer<?> namespaceSerializer) {
            TypeSerializer[] timerSerializers = new TypeSerializer[]{keySerializer, namespaceSerializer};
            return timerSerializers;
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public TypeSerializerSchemaCompatibility<TimerHeapInternalTimer<K, N>> resolveSchemaCompatibility(TypeSerializer<TimerHeapInternalTimer<K, N>> newSerializer) {
            TypeSerializerSnapshot[] nestedSnapshots = (TypeSerializerSnapshot[])this.getNestedSerializersAndConfigs().stream().map(t -> (TypeSerializerSnapshot)t.f1).toArray(TypeSerializerSnapshot[]::new);
            return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(newSerializer, new TimerSerializerSnapshot(), nestedSnapshots);
        }
    }
}

