/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndex;
import org.apache.flink.util.Preconditions;

@ThreadSafe
public class HsFileDataIndexImpl
implements HsFileDataIndex {
    @GuardedBy(value="lock")
    private final List<TreeMap<Integer, InternalRegion>> subpartitionFirstBufferIndexInternalRegions;
    private final Object lock = new Object();

    public HsFileDataIndexImpl(int numSubpartitions) {
        this.subpartitionFirstBufferIndexInternalRegions = new ArrayList<TreeMap<Integer, InternalRegion>>(numSubpartitions);
        for (int subpartitionId = 0; subpartitionId < numSubpartitions; ++subpartitionId) {
            this.subpartitionFirstBufferIndexInternalRegions.add(new TreeMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<HsFileDataIndex.ReadableRegion> getReadableRegion(int subpartitionId, int bufferIndex, int consumingOffset) {
        Object object = this.lock;
        synchronized (object) {
            return this.getInternalRegion(subpartitionId, bufferIndex).map(internalRegion -> ((InternalRegion)internalRegion).toReadableRegion(bufferIndex, consumingOffset)).filter(internalRegion -> internalRegion.numReadable > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBuffers(List<HsFileDataIndex.SpilledBuffer> spilledBuffers) {
        Map<Integer, List<InternalRegion>> subpartitionInternalRegions = HsFileDataIndexImpl.convertToInternalRegions(spilledBuffers);
        Object object = this.lock;
        synchronized (object) {
            subpartitionInternalRegions.forEach((subpartition, internalRegions) -> {
                TreeMap<Integer, InternalRegion> treeMap = this.subpartitionFirstBufferIndexInternalRegions.get((int)subpartition);
                for (InternalRegion internalRegion : internalRegions) {
                    treeMap.put(internalRegion.firstBufferIndex, internalRegion);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markBufferReleased(int subpartitionId, int bufferIndex) {
        Object object = this.lock;
        synchronized (object) {
            this.getInternalRegion(subpartitionId, bufferIndex).ifPresent(internalRegion -> ((InternalRegion)internalRegion).markBufferReleased(bufferIndex));
        }
    }

    @GuardedBy(value="lock")
    private Optional<InternalRegion> getInternalRegion(int subpartitionId, int bufferIndex) {
        return Optional.ofNullable(this.subpartitionFirstBufferIndexInternalRegions.get(subpartitionId).floorEntry(bufferIndex)).map(Map.Entry::getValue).filter(internalRegion -> ((InternalRegion)internalRegion).containBuffer(bufferIndex));
    }

    private static Map<Integer, List<InternalRegion>> convertToInternalRegions(List<HsFileDataIndex.SpilledBuffer> spilledBuffers) {
        HsFileDataIndex.SpilledBuffer firstBufferOfCurrentRegion;
        if (spilledBuffers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<InternalRegion>> internalRegionsBySubpartition = new HashMap<Integer, List<InternalRegion>>();
        Iterator<HsFileDataIndex.SpilledBuffer> iterator = spilledBuffers.iterator();
        HsFileDataIndex.SpilledBuffer lastBufferOfCurrentRegion = firstBufferOfCurrentRegion = iterator.next();
        while (iterator.hasNext()) {
            HsFileDataIndex.SpilledBuffer currentBuffer = iterator.next();
            if (currentBuffer.subpartitionId != firstBufferOfCurrentRegion.subpartitionId || currentBuffer.bufferIndex != lastBufferOfCurrentRegion.bufferIndex + 1) {
                HsFileDataIndexImpl.addInternalRegionToMap(firstBufferOfCurrentRegion, lastBufferOfCurrentRegion, internalRegionsBySubpartition);
                firstBufferOfCurrentRegion = currentBuffer;
            }
            lastBufferOfCurrentRegion = currentBuffer;
        }
        HsFileDataIndexImpl.addInternalRegionToMap(firstBufferOfCurrentRegion, lastBufferOfCurrentRegion, internalRegionsBySubpartition);
        return internalRegionsBySubpartition;
    }

    private static void addInternalRegionToMap(HsFileDataIndex.SpilledBuffer firstBufferInRegion, HsFileDataIndex.SpilledBuffer lastBufferInRegion, Map<Integer, List<InternalRegion>> internalRegionsBySubpartition) {
        Preconditions.checkArgument(firstBufferInRegion.subpartitionId == lastBufferInRegion.subpartitionId);
        Preconditions.checkArgument(firstBufferInRegion.bufferIndex <= lastBufferInRegion.bufferIndex);
        internalRegionsBySubpartition.computeIfAbsent(firstBufferInRegion.subpartitionId, ArrayList::new).add(new InternalRegion(firstBufferInRegion.bufferIndex, firstBufferInRegion.fileOffset, lastBufferInRegion.bufferIndex - firstBufferInRegion.bufferIndex + 1));
    }

    private static class InternalRegion {
        private final int firstBufferIndex;
        private final long firstBufferOffset;
        private final int numBuffers;
        private final boolean[] released;

        private InternalRegion(int firstBufferIndex, long firstBufferOffset, int numBuffers) {
            this.firstBufferIndex = firstBufferIndex;
            this.firstBufferOffset = firstBufferOffset;
            this.numBuffers = numBuffers;
            this.released = new boolean[numBuffers];
            Arrays.fill(this.released, false);
        }

        private boolean containBuffer(int bufferIndex) {
            return bufferIndex >= this.firstBufferIndex && bufferIndex < this.firstBufferIndex + this.numBuffers;
        }

        private HsFileDataIndex.ReadableRegion toReadableRegion(int bufferIndex, int consumingOffset) {
            int nSkip = bufferIndex - this.firstBufferIndex;
            int nReadable = 0;
            while (nSkip + nReadable < this.numBuffers && this.released[nSkip + nReadable] && bufferIndex + nReadable > consumingOffset) {
                ++nReadable;
            }
            return new HsFileDataIndex.ReadableRegion(nSkip, nReadable, this.firstBufferOffset);
        }

        private void markBufferReleased(int bufferIndex) {
            this.released[bufferIndex - this.firstBufferIndex] = true;
        }
    }
}

