/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.utils;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.io.Encoder;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.util.Utf8;

public final class DataOutputEncoder
extends Encoder {
    private DataOutput out;

    public void setOut(DataOutput out) {
        this.out = out;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void writeNull() {
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.out.writeBoolean(b);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.out.writeInt(n);
    }

    @Override
    public void writeLong(long n) throws IOException {
        this.out.writeLong(n);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.out.writeFloat(f);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.out.writeDouble(d);
    }

    @Override
    public void writeEnum(int e) throws IOException {
        this.out.writeInt(e);
    }

    @Override
    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.out.write(bytes, start, len);
    }

    @Override
    public void writeBytes(byte[] bytes, int start, int len) throws IOException {
        this.out.writeInt(len);
        if (len > 0) {
            this.out.write(bytes, start, len);
        }
    }

    @Override
    public void writeBytes(ByteBuffer bytes) throws IOException {
        int num = bytes.remaining();
        this.out.writeInt(num);
        if (num > 0) {
            this.writeFixed(bytes);
        }
    }

    @Override
    public void writeString(String str) throws IOException {
        byte[] bytes = Utf8.getBytesFor(str);
        this.writeBytes(bytes, 0, bytes.length);
    }

    @Override
    public void writeString(Utf8 utf8) throws IOException {
        this.writeBytes(utf8.getBytes(), 0, utf8.getByteLength());
    }

    @Override
    public void writeArrayStart() {
    }

    @Override
    public void setItemCount(long itemCount) throws IOException {
        if (itemCount > 0L) {
            DataOutputEncoder.writeVarLongCount(this.out, itemCount);
        }
    }

    @Override
    public void startItem() {
    }

    @Override
    public void writeArrayEnd() throws IOException {
        this.out.write(0);
    }

    @Override
    public void writeMapStart() {
    }

    @Override
    public void writeMapEnd() throws IOException {
        this.out.write(0);
    }

    @Override
    public void writeIndex(int unionIndex) throws IOException {
        this.out.writeInt(unionIndex);
    }

    public static void writeVarLongCount(DataOutput out, long val) throws IOException {
        if (val < 0L) {
            throw new IOException("Illegal count (must be non-negative): " + val);
        }
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((int)val | 0x80);
            val >>>= 7;
        }
        out.write((int)val);
    }
}

