/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.store.connector.source.FileStoreSourceSplit;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.util.InstantiationUtil;

public class FileStoreSourceSplitSerializer
implements SimpleVersionedSerializer<FileStoreSourceSplit> {
    public int getVersion() {
        return 1;
    }

    public byte[] serialize(FileStoreSourceSplit split) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        view.writeUTF(split.splitId());
        InstantiationUtil.serializeObject((OutputStream)view, (Object)split.split());
        view.writeLong(split.recordsToSkip());
        return out.toByteArray();
    }

    public FileStoreSourceSplit deserialize(int version, byte[] serialized) throws IOException {
        Split split;
        ByteArrayInputStream in = new ByteArrayInputStream(serialized);
        DataInputViewStreamWrapper view = new DataInputViewStreamWrapper((InputStream)in);
        String splitId = view.readUTF();
        try {
            split = (Split)InstantiationUtil.deserializeObject((InputStream)in, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        long recordsToSkip = view.readLong();
        return new FileStoreSourceSplit(splitId, split, recordsToSkip);
    }
}

