/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.lookup.RocksDBState;
import org.apache.flink.util.Preconditions;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksDBSetState
extends RocksDBState<List<byte[]>> {
    private static final byte[] EMPTY = new byte[0];

    public RocksDBSetState(RocksDB db, ColumnFamilyHandle columnFamily, TypeSerializer<RowData> keySerializer, TypeSerializer<RowData> valueSerializer, long lruCacheSize) {
        super(db, columnFamily, keySerializer, valueSerializer, lruCacheSize);
    }

    public List<RowData> get(RowData key) throws IOException {
        RocksDBState.ByteArray keyBytes = this.wrap(this.serializeKey(key));
        ArrayList<byte[]> valueBytes = (ArrayList<byte[]>)this.cache.getIfPresent((Object)keyBytes);
        if (valueBytes == null) {
            valueBytes = new ArrayList<byte[]>();
            RocksIterator iterator = this.db.newIterator(this.columnFamily);
            Object object = null;
            try {
                iterator.seek(keyBytes.bytes);
                while (iterator.isValid() && this.startWithKeyPrefix(keyBytes.bytes, iterator.key())) {
                    byte[] rawKeyBytes = iterator.key();
                    byte[] value = Arrays.copyOfRange(rawKeyBytes, keyBytes.bytes.length, rawKeyBytes.length);
                    valueBytes.add(value);
                    iterator.next();
                }
            }
            catch (Throwable rawKeyBytes) {
                object = rawKeyBytes;
                throw rawKeyBytes;
            }
            finally {
                if (iterator != null) {
                    if (object != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable rawKeyBytes) {
                            ((Throwable)object).addSuppressed(rawKeyBytes);
                        }
                    } else {
                        iterator.close();
                    }
                }
            }
            this.cache.put((Object)keyBytes, valueBytes);
        }
        ArrayList<RowData> values = new ArrayList<RowData>(valueBytes.size());
        for (byte[] value : valueBytes) {
            this.valueInputView.setBuffer(value);
            values.add((RowData)this.valueSerializer.deserialize((DataInputView)this.valueInputView));
        }
        return values;
    }

    public void retract(RowData key, RowData value) throws IOException {
        try {
            byte[] bytes = this.invalidKeyAndGetKVBytes(key, value);
            if (this.db.get(this.columnFamily, bytes) != null) {
                this.db.delete(this.columnFamily, this.writeOptions, bytes);
            }
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    public void add(RowData key, RowData value) throws IOException {
        try {
            byte[] bytes = this.invalidKeyAndGetKVBytes(key, value);
            this.db.put(this.columnFamily, this.writeOptions, bytes, EMPTY);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    private byte[] invalidKeyAndGetKVBytes(RowData key, RowData value) throws IOException {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        this.keyOutView.clear();
        this.keySerializer.serialize((Object)key, (DataOutputView)this.keyOutView);
        this.cache.invalidate((Object)this.wrap(this.keyOutView.getCopyOfBuffer()));
        this.valueSerializer.serialize((Object)value, (DataOutputView)this.keyOutView);
        return this.keyOutView.getCopyOfBuffer();
    }

    private boolean startWithKeyPrefix(byte[] keyPrefixBytes, byte[] rawKeyBytes) {
        if (rawKeyBytes.length < keyPrefixBytes.length) {
            return false;
        }
        int i = keyPrefixBytes.length;
        while (--i >= 0) {
            if (rawKeyBytes[i] == keyPrefixBytes[i]) continue;
            return false;
        }
        return true;
    }
}

