/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.topology.Vertex;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;

class PipelinedRegionExecutionView {
    private final SchedulingPipelinedRegion pipelinedRegion;
    private final Set<ExecutionVertexID> unfinishedVertices;

    PipelinedRegionExecutionView(SchedulingPipelinedRegion pipelinedRegion) {
        this.pipelinedRegion = Preconditions.checkNotNull(pipelinedRegion);
        this.unfinishedVertices = IterableUtils.toStream(pipelinedRegion.getVertices()).map(Vertex::getId).collect(Collectors.toSet());
    }

    public boolean isFinished() {
        return this.unfinishedVertices.isEmpty();
    }

    public void vertexFinished(ExecutionVertexID executionVertexId) {
        this.assertVertexInRegion(executionVertexId);
        this.unfinishedVertices.remove(executionVertexId);
    }

    public void vertexUnfinished(ExecutionVertexID executionVertexId) {
        this.assertVertexInRegion(executionVertexId);
        this.unfinishedVertices.add(executionVertexId);
    }

    private void assertVertexInRegion(ExecutionVertexID executionVertexId) {
        this.pipelinedRegion.getVertex(executionVertexId);
    }
}

