/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.predicate;

import java.util.List;
import java.util.Optional;
import org.apache.flink.table.store.file.predicate.CompareUtils;
import org.apache.flink.table.store.file.predicate.In;
import org.apache.flink.table.store.file.predicate.LeafFunction;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.types.logical.LogicalType;

public class NotIn
extends LeafFunction {
    private static final long serialVersionUID = 1L;
    public static final NotIn INSTANCE = new NotIn();

    private NotIn() {
    }

    @Override
    public boolean test(LogicalType type, Object field, List<Object> literals) {
        if (field == null) {
            return false;
        }
        for (Object literal : literals) {
            if (literal != null && CompareUtils.compareLiteral(type, literal, field) != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean test(LogicalType type, long rowCount, FieldStats fieldStats, List<Object> literals) {
        if (rowCount == fieldStats.nullCount()) {
            return false;
        }
        for (Object literal : literals) {
            if (literal != null && (CompareUtils.compareLiteral(type, literal, fieldStats.minValue()) != 0 || CompareUtils.compareLiteral(type, literal, fieldStats.maxValue()) != 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<LeafFunction> negate() {
        return Optional.of(In.INSTANCE);
    }
}

