/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.Collection;
import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskexecutor.PartitionProducerStateChecker;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.util.function.SupplierWithException;

public interface JobTable
extends AutoCloseable {
    public <E extends Exception> Job getOrCreateJob(JobID var1, SupplierWithException<? extends JobServices, E> var2) throws E;

    public Optional<Job> getJob(JobID var1);

    public Optional<Connection> getConnection(JobID var1);

    public Optional<Connection> getConnection(ResourceID var1);

    public Collection<Job> getJobs();

    public boolean isEmpty();

    public static interface JobServices {
        public LibraryCacheManager.ClassLoaderHandle getClassLoaderHandle();

        public void close();
    }

    public static interface Connection {
        public Job disconnect();

        public JobMasterId getJobMasterId();

        public JobMasterGateway getJobManagerGateway();

        public TaskManagerActions getTaskManagerActions();

        public CheckpointResponder getCheckpointResponder();

        public GlobalAggregateManager getGlobalAggregateManager();

        public LibraryCacheManager.ClassLoaderHandle getClassLoaderHandle();

        public ResultPartitionConsumableNotifier getResultPartitionConsumableNotifier();

        public PartitionProducerStateChecker getPartitionStateChecker();

        public JobID getJobId();

        public ResourceID getResourceId();
    }

    public static interface Job {
        public boolean isConnected();

        public JobID getJobId();

        public Optional<Connection> asConnection();

        public Connection connect(ResourceID var1, JobMasterGateway var2, TaskManagerActions var3, CheckpointResponder var4, GlobalAggregateManager var5, ResultPartitionConsumableNotifier var6, PartitionProducerStateChecker var7);

        public void close();
    }
}

