/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.connector.kafka.source.enumerator.initializer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.store.shaded.connector.kafka.source.enumerator.initializer.OffsetsInitializer;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.TopicPartition;

class TimestampOffsetsInitializer
implements OffsetsInitializer {
    private static final long serialVersionUID = 2932230571773627233L;
    private final long startingTimestamp;

    TimestampOffsetsInitializer(long startingTimestamp) {
        this.startingTimestamp = startingTimestamp;
    }

    @Override
    public Map<TopicPartition, Long> getPartitionOffsets(Collection<TopicPartition> partitions, OffsetsInitializer.PartitionOffsetsRetriever partitionOffsetsRetriever) {
        HashMap<TopicPartition, Long> startingTimestamps = new HashMap<TopicPartition, Long>();
        HashMap<TopicPartition, Long> initialOffsets = new HashMap<TopicPartition, Long>();
        Map<TopicPartition, Long> endOffsets = partitionOffsetsRetriever.endOffsets(partitions);
        partitions.forEach(tp -> startingTimestamps.put((TopicPartition)tp, this.startingTimestamp));
        partitionOffsetsRetriever.offsetsForTimes(startingTimestamps).forEach((tp, offsetMetadata) -> {
            if (offsetMetadata != null) {
                initialOffsets.put((TopicPartition)tp, offsetMetadata.offset());
            } else {
                initialOffsets.put((TopicPartition)tp, (Long)endOffsets.get(tp));
            }
        });
        return initialOffsets;
    }

    @Override
    public OffsetResetStrategy getAutoOffsetResetStrategy() {
        return OffsetResetStrategy.NONE;
    }
}

