/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.io.IOException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.table.store.file.utils.AtomicFileWriter;
import org.apache.flink.table.store.file.utils.AtomicFsDataOutputStream;

public class RecoverableAtomicFileWriter
implements AtomicFileWriter {
    private final RecoverableWriter recoverableWriter;

    public RecoverableAtomicFileWriter(RecoverableWriter recoverableWriter) {
        this.recoverableWriter = recoverableWriter;
    }

    @Override
    public AtomicFsDataOutputStream open(Path path) throws IOException {
        RecoverableFsDataOutputStream out = this.recoverableWriter.open(path);
        return new RecoverableAtomicFsDataOutputStream(out);
    }

    private static class RecoverableAtomicFsDataOutputStream
    extends AtomicFsDataOutputStream {
        private final RecoverableFsDataOutputStream out;

        public RecoverableAtomicFsDataOutputStream(RecoverableFsDataOutputStream out) {
            this.out = out;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void sync() throws IOException {
            this.out.sync();
        }

        public long getPos() throws IOException {
            return this.out.getPos();
        }

        @Override
        public boolean closeAndCommit() throws IOException {
            RecoverableFsDataOutputStream.Committer committer = this.out.closeForCommit();
            committer.commit();
            return true;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

