/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.util.Map;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.connector.base.source.hybrid.HybridSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.source.StaticFileStoreSplitEnumerator;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.log.LogSourceProvider;

public class LogHybridSourceFactory
implements HybridSource.SourceFactory<RowData, Source<RowData, ?, ?>, StaticFileStoreSplitEnumerator> {
    private final LogSourceProvider provider;

    public LogHybridSourceFactory(LogSourceProvider provider) {
        this.provider = provider;
    }

    public Source<RowData, ?, ?> create(HybridSource.SourceSwitchContext<StaticFileStoreSplitEnumerator> context) {
        StaticFileStoreSplitEnumerator enumerator = (StaticFileStoreSplitEnumerator)context.getPreviousEnumerator();
        Snapshot snapshot = enumerator.snapshot();
        Map<Integer, Long> logOffsets = null;
        if (snapshot != null) {
            logOffsets = snapshot.getLogOffsets();
        }
        return this.provider.createSource(logOffsets);
    }
}

