/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.util.Objects;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.table.store.table.source.Split;

public class FileStoreSourceSplit
implements SourceSplit {
    private final String id;
    private final Split split;
    private final long recordsToSkip;

    public FileStoreSourceSplit(String id, Split split) {
        this(id, split, 0L);
    }

    public FileStoreSourceSplit(String id, Split split, long recordsToSkip) {
        this.id = id;
        this.split = split;
        this.recordsToSkip = recordsToSkip;
    }

    public Split split() {
        return this.split;
    }

    public long recordsToSkip() {
        return this.recordsToSkip;
    }

    public String splitId() {
        return this.id;
    }

    public FileStoreSourceSplit updateWithRecordsToSkip(long recordsToSkip) {
        return new FileStoreSourceSplit(this.id, this.split, recordsToSkip);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileStoreSourceSplit other = (FileStoreSourceSplit)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.split, other.split) && this.recordsToSkip == other.recordsToSkip;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.split, this.recordsToSkip);
    }
}

