/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.codegen;

import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryRowDataUtil;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.store.codegen.CodeGenLoader;
import org.apache.flink.table.store.codegen.CodeGenerator;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class CodeGenUtils {
    public static final Projection<RowData, BinaryRowData> EMPTY_PROJECTION = input -> BinaryRowDataUtil.EMPTY_ROW;

    public static Projection<RowData, BinaryRowData> newProjection(RowType inputType, int[] mapping) {
        if (mapping.length == 0) {
            return EMPTY_PROJECTION;
        }
        Projection projection = (Projection)CodeGenLoader.getInstance().discover(CodeGenerator.class).generateProjection("Projection", inputType, mapping).newInstance(CodeGenUtils.class.getClassLoader());
        return projection;
    }

    public static NormalizedKeyComputer newNormalizedKeyComputer(List<LogicalType> fieldTypes, String name) {
        return (NormalizedKeyComputer)CodeGenLoader.getInstance().discover(CodeGenerator.class).generateNormalizedKeyComputer(fieldTypes, name).newInstance(CodeGenUtils.class.getClassLoader());
    }

    public static GeneratedRecordComparator generateRecordComparator(List<LogicalType> fieldTypes, String name) {
        return CodeGenLoader.getInstance().discover(CodeGenerator.class).generateRecordComparator(fieldTypes, name);
    }

    public static RecordComparator newRecordComparator(List<LogicalType> fieldTypes, String name) {
        return (RecordComparator)CodeGenUtils.generateRecordComparator(fieldTypes, name).newInstance(CodeGenUtils.class.getClassLoader());
    }
}

