/*
 * Decompiled with CFR 0.152.
 */
package flex.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.Task;

public final class HtmlWrapperTask
extends Task
implements DynamicAttribute {
    private static final String TEMPLATE_DIR = "/templates/swfobject/";
    private static final String INDEX_TEMPLATE_HTML = "index.template.html";
    private static final String SWFOBJECT_JS = "swfobject.js";
    private static final String HISTORY_CSS = "history/history.css";
    private static final String HISTORY_JS = "history/history.js";
    private static final String HISTORY_FRAME_HTML = "history/historyFrame.html";
    private static final String EXPRESSINSTALL_SWF = "expressInstall.swf";
    private static final String HTML_COMMENT_DELIMITER = "--";
    private String application;
    private String bgcolor = "white";
    private String fileName = "index.html";
    private String height = "400";
    private String output;
    private String swf;
    private String title = "Flex Application";
    private String width = "400";
    private boolean history = false;
    private boolean expressInstall = false;
    private boolean versionDetection = true;
    private String versionMajor = "10";
    private String versionMinor = "0";
    private String versionRevision = "0";
    private String useBrowserHistory;
    private String expressInstallSwf = "";

    public HtmlWrapperTask() {
        this.setTaskName("html-wrapper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        if (this.swf == null) {
            throw new BuildException("The <html-wrapper> task requires the 'swf' attribute.", this.getLocation());
        }
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) throw new BuildException("Missing resources", this.getLocation());
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        String path = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            if (this.output != null) {
                File outputDir = new File(this.output);
                if (outputDir.exists() && outputDir.isDirectory()) {
                    path = this.output + File.separatorChar + this.fileName;
                } else {
                    String base = this.getProject().getBaseDir().getAbsolutePath();
                    outputDir = new File(base + File.separatorChar + this.output);
                    if (!outputDir.exists() || !outputDir.isDirectory()) throw new BuildException("output directory does not exist: " + this.output);
                    path = base + File.separatorChar + this.output + File.separatorChar + this.fileName;
                }
            } else {
                path = this.fileName;
            }
            printWriter = new PrintWriter(new FileWriter(path));
            while ((line = bufferedReader.readLine()) != null) {
                printWriter.println(this.substitute(line));
            }
            return;
        }
        catch (IOException ioException) {
            System.err.println("Error outputting resource: " + path);
            ioException.printStackTrace();
            return;
        }
        finally {
            try {
                bufferedReader.close();
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private InputStream getInputStream() {
        String[] resources;
        if (this.history) {
            if (this.expressInstall) {
                this.expressInstallSwf = EXPRESSINSTALL_SWF;
                resources = new String[]{SWFOBJECT_JS, HISTORY_FRAME_HTML, HISTORY_JS, HISTORY_CSS, EXPRESSINSTALL_SWF};
                this.versionDetection = true;
            } else {
                resources = new String[]{SWFOBJECT_JS, HISTORY_FRAME_HTML, HISTORY_JS, HISTORY_CSS};
            }
            this.useBrowserHistory = HTML_COMMENT_DELIMITER;
        } else {
            if (this.expressInstall) {
                this.expressInstallSwf = EXPRESSINSTALL_SWF;
                resources = new String[]{SWFOBJECT_JS, EXPRESSINSTALL_SWF};
                this.versionDetection = true;
            } else {
                resources = new String[]{SWFOBJECT_JS};
            }
            this.useBrowserHistory = "";
        }
        if (!this.versionDetection) {
            this.versionMajor = "0";
            this.versionMinor = "0";
            this.versionRevision = "0";
            this.expressInstallSwf = "";
        }
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/templates/swfobject/index.template.html");
        this.outputResources(TEMPLATE_DIR, resources);
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputResources(String resourceDir, String[] resources) {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream bufferedOutputStream = null;
        for (int i = 0; i < resources.length; ++i) {
            try {
                int len;
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(resourceDir + resources[i]);
                bufferedInputStream = new BufferedInputStream(inputStream);
                String path = null;
                if (this.output != null) {
                    File outputDir = new File(this.output);
                    if (outputDir.exists() && outputDir.isDirectory()) {
                        path = this.output + File.separatorChar + resources[i];
                    } else {
                        String base = this.getProject().getBaseDir().getAbsolutePath();
                        outputDir = new File(base + File.separatorChar + this.output);
                        if (!outputDir.exists() || !outputDir.isDirectory()) throw new BuildException("output directory does not exist: " + this.output);
                        path = base + File.separatorChar + this.output + File.separatorChar + resources[i];
                    }
                } else {
                    path = resources[i];
                }
                File file = new File(path);
                file.getParentFile().mkdirs();
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                byte[] byteArr = new byte[8192];
                while ((len = bufferedInputStream.read(byteArr, 0, 8192)) != -1) {
                    ((BufferedOutputStream)bufferedOutputStream).write(byteArr, 0, len);
                }
                continue;
            }
            catch (IOException ioException) {
                System.err.println("Error outputting resource: " + resources[i]);
                ioException.printStackTrace();
                continue;
            }
            finally {
                try {
                    bufferedOutputStream.close();
                    bufferedInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
    }

    public void setDynamicAttribute(String name, String value) {
        if (name.equals("version-major")) {
            this.versionMajor = value;
        } else if (name.equals("version-minor")) {
            this.versionMinor = value;
        } else if (name.equals("version-revision")) {
            this.versionRevision = value;
        } else if (name.equals("express-install")) {
            this.expressInstall = Boolean.parseBoolean(value);
        } else if (name.equals("version-detection")) {
            this.versionDetection = Boolean.parseBoolean(value);
        } else {
            throw new BuildException("The <html-wrapper> task doesn't support the \"" + name + "\" attribute.", this.getLocation());
        }
    }

    public void setFile(String fileName) {
        this.fileName = fileName;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setHistory(boolean history) {
        this.history = history;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setSwf(String swf) {
        this.swf = swf.replace('\\', '/');
        if (this.application == null) {
            this.application = this.swf;
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    private String substitute(String input) {
        String result = input.replaceAll("\\$\\{application\\}", this.application);
        result = result.replaceAll("\\$\\{bgcolor\\}", this.bgcolor);
        result = result.replaceAll("\\$\\{expressInstallSwf\\}", this.expressInstallSwf);
        result = result.replaceAll("\\$\\{height\\}", this.height);
        result = result.replaceAll("\\$\\{swf\\}", this.swf);
        result = result.replaceAll("\\$\\{title\\}", this.title);
        result = result.replaceAll("\\$\\{version_major\\}", this.versionMajor);
        result = result.replaceAll("\\$\\{version_minor\\}", this.versionMinor);
        result = result.replaceAll("\\$\\{version_revision\\}", this.versionRevision);
        result = result.replaceAll("\\$\\{width\\}", this.width);
        result = result.replaceAll("\\$\\{useBrowserHistory\\}", this.useBrowserHistory);
        return result;
    }
}

