/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.maven.osgicheck.impl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.felix.maven.osgicheck.impl.Check;
import org.apache.felix.maven.osgicheck.impl.CheckContext;
import org.apache.felix.maven.osgicheck.impl.checks.ConsumerProviderTypeCheck;
import org.apache.felix.maven.osgicheck.impl.checks.ImportExportCheck;
import org.apache.felix.maven.osgicheck.impl.checks.SCRCheck;
import org.apache.felix.maven.osgicheck.impl.featureutil.ManifestUtil;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.xml.Xpp3Dom;
import org.apache.maven.shared.utils.xml.Xpp3DomBuilder;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class CheckMojo
extends AbstractMojo {
    @Parameter(defaultValue="DEFAULT")
    protected Mode mode;
    @Parameter
    protected String config;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private ArchiverManager archiverManager;

    private boolean isOSGiProject() {
        return "bundle".equals(this.project.getPackaging()) || "jar".equals(this.project.getPackaging());
    }

    private File getBundle() {
        return this.project.getArtifact().getFile();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isOSGiProject()) {
            if (this.mode != Mode.OFF) {
                this.getLog().debug((CharSequence)"Checking OSGi project...");
                this.doExecute();
            } else {
                this.getLog().debug((CharSequence)"Skipping check...disabled by configuration");
            }
        } else {
            this.getLog().debug((CharSequence)"Skipping check...not an OSGi project");
        }
    }

    private void doExecute() throws MojoExecutionException, MojoFailureException {
        File bundle = this.getBundle();
        this.getLog().debug((CharSequence)("Checking " + bundle));
        Xpp3Dom pomCfg = null;
        if (this.config != null && !this.config.trim().isEmpty()) {
            pomCfg = Xpp3DomBuilder.build((Reader)new StringReader("<c>" + this.config + "</c>"));
        }
        Xpp3Dom configuration = pomCfg;
        ArrayList<CheckResult> results = new ArrayList<CheckResult>();
        try {
            final Manifest mf = ManifestUtil.getManifest(bundle);
            String manifestVersion = mf.getMainAttributes().getValue("Bundle-ManifestVersion");
            if (!"2".equals(manifestVersion)) {
                throw new MojoExecutionException("Bundle manifestversion 2 not found in manifest (" + manifestVersion + ")");
            }
            File rootDir = null;
            try {
                Class[] checks;
                final File dir = rootDir = this.extract(bundle);
                for (Class c : checks = new Class[]{ImportExportCheck.class, SCRCheck.class, ConsumerProviderTypeCheck.class}) {
                    Map config;
                    Check check = (Check)c.newInstance();
                    if (configuration != null) {
                        Xpp3Dom cfg = configuration.getChild(check.getName());
                        if (cfg != null) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            for (Xpp3Dom child : cfg.getChildren()) {
                                map.put(child.getName(), child.getValue());
                            }
                            config = map;
                        } else {
                            config = Collections.emptyMap();
                        }
                    } else {
                        config = Collections.emptyMap();
                    }
                    this.getLog().debug((CharSequence)("Configuration for " + check.getName() + " : " + config));
                    final CheckResult result = new CheckResult();
                    result.mode = this.mode;
                    if (config.get("mode") != null) {
                        result.mode = Mode.valueOf((String)config.get("mode"));
                    }
                    if (result.mode != Mode.OFF) {
                        this.getLog().debug((CharSequence)("Executing " + check.getName() + "..."));
                        check.check(new CheckContext(){
                            private final Map<String, String> conf;
                            {
                                this.conf = config;
                            }

                            @Override
                            public File getRootDir() {
                                return dir;
                            }

                            @Override
                            public Manifest getManifest() {
                                return mf;
                            }

                            @Override
                            public Map<String, String> getConfiguration() {
                                return this.conf;
                            }

                            @Override
                            public Log getLog() {
                                return CheckMojo.this.getLog();
                            }

                            @Override
                            public void reportWarning(String message) {
                                result.warnings.add(message);
                            }

                            @Override
                            public void reportError(String message) {
                                result.errors.add(message);
                            }
                        });
                        results.add(result);
                        this.getLog().debug((CharSequence)("Finished " + check.getName() + "..."));
                        continue;
                    }
                    this.getLog().debug((CharSequence)("Skipping executing " + check.getName()));
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            finally {
                if (rootDir != null) {
                    FileUtils.deleteDirectory((File)rootDir);
                }
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
        for (CheckResult result : results) {
            if (result.mode == Mode.ERRORS_ONLY) continue;
            for (String msg : result.warnings) {
                this.getLog().warn((CharSequence)msg);
            }
        }
        boolean hasErrors = false;
        for (CheckResult result : results) {
            for (String msg : result.errors) {
                hasErrors = true;
                this.getLog().error((CharSequence)msg);
            }
        }
        if (hasErrors) {
            throw new MojoExecutionException("Check detected errors. See log output for error messages.");
        }
        for (CheckResult result : results) {
            if (result.mode != Mode.STRICT || result.warnings.isEmpty()) continue;
            throw new MojoExecutionException("Check detected warnings and strict mode is enabled. See log output for warning messages.");
        }
    }

    private File extract(File file) throws IOException, MojoExecutionException {
        File rootDir = Files.createTempDirectory("osgicheck", new FileAttribute[0]).toFile();
        UnArchiver zipUnarchiver = null;
        try {
            zipUnarchiver = this.archiverManager.getUnArchiver(file);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Impossible to unarchive the '" + file + "' file: " + e.getMessage());
        }
        zipUnarchiver.setDestDirectory(rootDir);
        zipUnarchiver.setSourceFile(file);
        zipUnarchiver.extract();
        return rootDir;
    }

    public static class CheckResult {
        public Mode mode;
        public final List<String> warnings = new ArrayList<String>();
        public final List<String> errors = new ArrayList<String>();
    }

    public static enum Mode {
        OFF,
        DEFAULT,
        STRICT,
        ERRORS_ONLY;

    }
}

