/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.discovery;

import org.apache.felix.upnp.basedriver.controller.DevicesInfo;
import org.apache.felix.upnp.basedriver.controller.DriverController;
import org.apache.felix.upnp.tester.Activator;
import org.apache.felix.upnp.tester.Mediator;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class DriverProxy
implements ServiceListener {
    private DevicesInfo devicesInfo;
    private DriverController drvController;
    static /* synthetic */ Class class$org$apache$felix$upnp$basedriver$controller$DevicesInfo;

    public DriverProxy() {
        ServiceReference sr = Activator.context.getServiceReference((class$org$apache$felix$upnp$basedriver$controller$DevicesInfo == null ? (class$org$apache$felix$upnp$basedriver$controller$DevicesInfo = DriverProxy.class$("org.apache.felix.upnp.basedriver.controller.DevicesInfo")) : class$org$apache$felix$upnp$basedriver$controller$DevicesInfo).getName());
        if (sr != null) {
            this.devicesInfo = (DevicesInfo)Activator.context.getService(sr);
            this.drvController = (DriverController)this.devicesInfo;
            Mediator.getControlPoint().enableMenus(true, this.getLogLevel(), this.getCyberDebug());
            Mediator.getTreeViewer().setPopupMenuEnabled(true);
        }
        String filter = "(objectClass=" + (class$org$apache$felix$upnp$basedriver$controller$DevicesInfo == null ? (class$org$apache$felix$upnp$basedriver$controller$DevicesInfo = DriverProxy.class$("org.apache.felix.upnp.basedriver.controller.DevicesInfo")) : class$org$apache$felix$upnp$basedriver$controller$DevicesInfo).getName() + ")";
        try {
            Activator.context.addServiceListener((ServiceListener)this, filter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isDriverAvailable() {
        return this.drvController != null;
    }

    public String getDeviceDescriptionURI(String udn) {
        if (this.devicesInfo != null) {
            return this.devicesInfo.getLocationURL(udn);
        }
        return "";
    }

    public String getServiceDescriptionURI(String udn, String serviceId) {
        if (this.devicesInfo != null) {
            return this.devicesInfo.getSCPDURL(udn, serviceId);
        }
        return null;
    }

    public String resolveRelativeUrl(String udn, String link) {
        if (this.devicesInfo != null) {
            return this.devicesInfo.resolveRelativeUrl(udn, link);
        }
        return null;
    }

    public boolean getCyberDebug() {
        if (this.drvController != null) {
            return this.drvController.getCyberDebug();
        }
        return false;
    }

    public void setCyberDebug(boolean b) {
        if (this.drvController != null) {
            this.drvController.setCyberDebug(b);
        }
    }

    public int getLogLevel() {
        if (this.drvController != null) {
            return this.drvController.getLogLevel();
        }
        return 0;
    }

    public void setLogLevel(int value) {
        if (this.drvController != null) {
            this.drvController.setLogLevel(value);
        }
    }

    public void doSearch(String target) {
        if (this.drvController != null) {
            this.drvController.search(target);
        }
    }

    public void serviceChanged(ServiceEvent e) {
        switch (e.getType()) {
            case 1: {
                Object service = Activator.context.getService(e.getServiceReference());
                if (service == null) break;
                this.devicesInfo = (DevicesInfo)service;
                this.drvController = (DriverController)this.devicesInfo;
                Mediator.getControlPoint().enableMenus(true, this.getLogLevel(), this.getCyberDebug());
                Mediator.getTreeViewer().setPopupMenuEnabled(true);
                break;
            }
            case 4: {
                this.devicesInfo = null;
                this.drvController = null;
                Mediator.getControlPoint().enableMenus(false, 0, false);
                Mediator.getTreeViewer().setPopupMenuEnabled(false);
            }
        }
    }

    public void close() {
        Activator.context.removeServiceListener((ServiceListener)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

