/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.core.upnp;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.felix.upnp.basedriver.importer.core.upnp.UPnPServiceImpl;
import org.apache.felix.upnp.basedriver.importer.util.DeviceSetup;
import org.cybergarage.upnp.Device;
import org.osgi.framework.BundleContext;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPIcon;
import org.osgi.service.upnp.UPnPService;

public class UPnPDeviceImpl
implements UPnPDevice {
    private Dictionary properties = new Hashtable();
    private Vector icons;
    private Hashtable services = new Hashtable();

    public UPnPDeviceImpl(Device dev, BundleContext context) {
        this.icons = new Vector();
        DeviceSetup.deviceSetup(this.properties, dev, this.icons, this.services);
    }

    public UPnPService getService(String serviceId) {
        return (UPnPServiceImpl)this.services.get(serviceId);
    }

    public UPnPService[] getServices() {
        Enumeration e = this.services.elements();
        if (e == null) {
            return null;
        }
        UPnPService[] uPnPser = new UPnPService[this.services.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            uPnPser[i] = (UPnPServiceImpl)e.nextElement();
            ++i;
        }
        return uPnPser;
    }

    public UPnPIcon[] getIcons(String locale) {
        if (locale != null) {
            return null;
        }
        if (this.icons.size() == 0) {
            return null;
        }
        return this.icons.toArray(new UPnPIcon[0]);
    }

    public Dictionary getDescriptions(String locale) {
        if (locale != null) {
            return null;
        }
        return this.properties;
    }

    public boolean existServiceType(String serviceType) {
        String[] services = (String[])this.properties.get("UPnP.service.type");
        if (services != null) {
            for (int i = 0; i < services.length; ++i) {
                if (!services[i].equals(serviceType)) continue;
                return true;
            }
        }
        return false;
    }

    public void setProperty(String property, Object obj) {
        this.properties.remove(property);
        this.properties.put(property, obj);
    }
}

