/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.core.upnp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.felix.upnp.basedriver.importer.util.HTTPRequestForIcon;
import org.apache.felix.upnp.basedriver.importer.util.ParseLocation;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.Icon;
import org.osgi.service.upnp.UPnPIcon;

public class UPnPIconImpl
implements UPnPIcon {
    private Icon icon;
    private Device cyberdev;

    public UPnPIconImpl(Icon cybericon, Device cyberdev) {
        this.icon = cybericon;
        this.cyberdev = cyberdev;
    }

    public String getMimeType() {
        return this.icon.getMimeType();
    }

    public int getWidth() {
        String width = this.icon.getWidth();
        if (width.length() == 0) {
            return -1;
        }
        return Integer.parseInt(width);
    }

    public int getHeight() {
        String higth = this.icon.getHeight();
        if (higth.length() == 0) {
            return -1;
        }
        return Integer.parseInt(higth);
    }

    public int getSize() {
        return -1;
    }

    public int getDepth() {
        String depth = this.icon.getDepth();
        if (depth.length() == 0) {
            return -1;
        }
        return Integer.parseInt(depth);
    }

    public InputStream getInputStream() throws IOException {
        String urlString = ParseLocation.getUrlBase(this.cyberdev.getLocation()) + this.icon.getURL();
        URL url = new URL(urlString);
        HTTPRequestForIcon requestor = new HTTPRequestForIcon(url);
        return requestor.getInputStream();
    }
}

