/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.controller.impl;

import org.apache.felix.upnp.basedriver.Activator;
import org.apache.felix.upnp.basedriver.controller.DevicesInfo;
import org.apache.felix.upnp.basedriver.controller.DriverController;
import org.apache.felix.upnp.basedriver.importer.core.MyCtrlPoint;
import org.apache.felix.upnp.basedriver.tool.Logger;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.Service;

public class DriverControllerImpl
implements DriverController,
DevicesInfo {
    private MyCtrlPoint myCtrl;
    private Logger logger = Activator.logger;

    public DriverControllerImpl(MyCtrlPoint myCtrl) {
        this.myCtrl = myCtrl;
    }

    public void setLogLevel(int n) {
        this.logger.setLogLevel(n);
    }

    public int getLogLevel() {
        return this.logger.getLogLevel();
    }

    public void setCyberDebug(boolean b) {
        this.logger.setCyberDebug(b);
    }

    public boolean getCyberDebug() {
        return this.logger.getCyberDebug();
    }

    public String getLocationURL(String udn) {
        if (this.myCtrl == null) {
            this.logger.WARNING("UPnP Importer is disabled. getLocationURL is not available");
            return null;
        }
        if (udn == null || udn.equals("")) {
            throw new IllegalArgumentException("Invalid udn paramenter");
        }
        Device device = this.myCtrl.getDevice(udn);
        if (device == null) {
            this.logger.WARNING("getLocationURL():: No device data available for UDN:" + udn);
            return null;
        }
        return device.getLocation();
    }

    public String getSCPDURL(String udn, String serviceId) {
        if (this.myCtrl == null) {
            this.logger.WARNING("UPnP Importer is disabled. getSCPDURL() is not available");
            return null;
        }
        if (udn == null || udn.equals("")) {
            throw new IllegalArgumentException("Invalid udn paramenter");
        }
        if (serviceId == null || serviceId.equals("")) {
            throw new IllegalArgumentException("Invalid serviceId paramenter");
        }
        Device device = this.myCtrl.getDevice(udn);
        if (device == null) {
            this.logger.WARNING("getSCPDURL():: No device data available for UDN: " + udn);
            return null;
        }
        Service service = device.getService(serviceId);
        if (service == null) {
            this.logger.WARNING("getSCPDURL():: No service data available for serviceId:" + serviceId + " of UDN " + udn);
            return null;
        }
        String scpd = service.getSCPDURL().trim();
        return this.resolveRelativeLink(device, scpd);
    }

    public String resolveRelativeUrl(String udn, String link) {
        if (this.myCtrl == null) {
            this.logger.WARNING("UPnP Importer is disabled. resolveRelativeUrl() is not available");
            return null;
        }
        if (udn == null || udn.equals("")) {
            throw new IllegalArgumentException("Invalid udn paramenter");
        }
        Device device = this.myCtrl.getDevice(udn);
        if (device == null) {
            this.logger.WARNING("resolveRelativeUrl():: No device data available for UDN: " + udn);
            return null;
        }
        return this.resolveRelativeLink(device, link);
    }

    private String resolveRelativeLink(Device device, String link) {
        if (device == null || link == null) {
            return null;
        }
        if (link.startsWith("http:")) {
            return link;
        }
        String hostname = "";
        String location = "";
        String urlBase = device.getURLBase().trim();
        if (urlBase.equals("")) {
            location = device.getLocation().trim();
            int endHostnameIdx = location.indexOf("/", 7);
            hostname = endHostnameIdx != -1 ? location.substring(0, endHostnameIdx) : location;
            if (link.startsWith("/")) {
                return hostname + link;
            }
            return location + link;
        }
        return urlBase + link;
    }

    public void search(String target) {
        if (this.myCtrl == null) {
            this.logger.WARNING("UPnP Importer is disabled. resolveRelativeUrl() is not available");
            return;
        }
        this.myCtrl.search(target);
    }
}

