/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.threaddump.internal;

import java.io.PrintWriter;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.threaddump.internal.Jdk14ThreadDumper;
import org.apache.felix.threaddump.internal.ThreadDumper;
import org.apache.felix.threaddump.internal.ThreadWriter;
import org.apache.felix.threaddump.internal.jdk5.Jdk15ThreadDumper;
import org.apache.felix.threaddump.internal.jdk6.Jdk16ThreadDumper;

final class ThreadDumpInventoryPrinter
implements InventoryPrinter {
    private static final String JAVA_SPECIFICATION_VERSION = "java.specification.version";
    private static final String JDK16_SPECIFICATION_VERSION = "1.6";
    private static final String JDK15_SPECIFICATION_VERSION = "1.5";

    ThreadDumpInventoryPrinter() {
    }

    public void print(PrintWriter printWriter, Format format, boolean isZip) {
        String javaSpecificationVersion = System.getProperty(JAVA_SPECIFICATION_VERSION);
        ThreadDumper delegated = JDK16_SPECIFICATION_VERSION.compareToIgnoreCase(javaSpecificationVersion) <= 0 ? new Jdk16ThreadDumper() : (JDK15_SPECIFICATION_VERSION.equalsIgnoreCase(javaSpecificationVersion) ? new Jdk15ThreadDumper() : new Jdk14ThreadDumper());
        ThreadWriter threadWriter = new ThreadWriter(printWriter);
        threadWriter.printHeader();
        delegated.printThreads(threadWriter);
    }
}

