/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.impl.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.systemready.CheckStatus;
import org.apache.felix.systemready.StateType;
import org.apache.felix.systemready.SystemReadyMonitor;
import org.apache.felix.systemready.SystemStatus;
import org.apache.felix.systemready.impl.servlet.StatusWriterJson;

class StatusReporter {
    private SystemReadyMonitor monitor;
    private StateType type;

    public StatusReporter(SystemReadyMonitor monitor, StateType type) {
        this.monitor = monitor;
        this.type = type;
    }

    public void reportState(HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        SystemStatus systemState = this.monitor.getStatus(this.type);
        if (systemState.getState() != CheckStatus.State.GREEN) {
            response.setStatus(503);
        }
        PrintWriter writer = response.getWriter();
        new StatusWriterJson(writer).write(systemState);
    }
}

