/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.command;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import junit.framework.Test;

public class TestListModel
extends AbstractListModel {
    private static final long serialVersionUID = 1L;
    private List<TestRecord> m_list = new ArrayList<TestRecord>();

    public Object getElementAt(int index) {
        if (index >= this.m_list.size()) {
            return null;
        }
        return this.m_list.get((int)index).m_name;
    }

    public Test getTestElementAt(int index) {
        return this.m_list.get((int)index).m_test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTest(Test test) {
        TestListModel testListModel = this;
        synchronized (testListModel) {
            TestRecord tr = new TestRecord();
            tr.m_test = test;
            tr.m_name = test.toString();
            this.m_list.add(tr);
        }
        this.fireContentsChanged(this, this.m_list.size() - 1, this.m_list.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTest(Test test) {
        int index = 1;
        TestListModel testListModel = this;
        synchronized (testListModel) {
            for (TestRecord t : this.m_list) {
                if (!t.m_test.equals(test)) continue;
                index = this.m_list.indexOf(t);
                this.m_list.remove(t);
                return;
            }
        }
        if (index != -1) {
            this.fireContentsChanged(this, index, index);
        }
    }

    public void clear() {
        this.m_list.clear();
    }

    public int getSize() {
        return this.m_list.size();
    }

    private class TestRecord {
        public Test m_test;
        public String m_name;

        private TestRecord() {
        }
    }
}

