/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.util.InvocationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Methods<T> {
    private Class<? extends T> returnType;
    private List<Class<?>> argumentTypes = new ArrayList();
    private Class<?> clazz;
    private Object object;
    private List<Method> methods;

    public Map<Method, InvocationResult<T>> map(Object ... args) {
        Collection<Method> set = this.retrieve();
        LinkedHashMap<Method, InvocationResult<T>> results = new LinkedHashMap<Method, InvocationResult<T>>();
        for (Method method : set) {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            results.put(method, InvocationResult.fromInvocation(method, this.object, args));
        }
        return results;
    }

    public Collection<InvocationResult<T>> invoke(Object ... args) {
        return this.map(args).values();
    }

    public Methods ofReturnType(Class<? extends T> clazz) {
        this.returnType = clazz;
        return this;
    }

    public Methods withParameter(Class<?> ... type) {
        this.argumentTypes.addAll(Arrays.asList(type));
        return this;
    }

    public Methods in(Object o) {
        this.object = o;
        this.clazz = o.getClass();
        return this;
    }

    public Methods in(Class<?> c) {
        this.clazz = c;
        this.object = null;
        return this;
    }

    private Collection<Method> retrieve() {
        Method[] list;
        if (this.methods != null) {
            return this.methods;
        }
        if (this.clazz == null) {
            throw new NullPointerException("Cannot retrieve method, class not set");
        }
        this.methods = new ArrayList<Method>();
        for (Method method : list = this.clazz.getDeclaredMethods()) {
            if (!this.matchReturnType(method) || !this.matchArgumentTypes(method)) continue;
            this.methods.add(method);
        }
        if (this.clazz.getSuperclass() != null) {
            this.traverse(this.methods, this.clazz.getSuperclass());
        }
        return this.methods;
    }

    private boolean matchReturnType(Method method) {
        if (this.returnType == null) {
            return method.getReturnType() == null;
        }
        return method.getReturnType() != null && this.returnType.isAssignableFrom(method.getReturnType());
    }

    private boolean matchArgumentTypes(Method method) {
        if (this.argumentTypes.size() != method.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < this.argumentTypes.size(); ++i) {
            Class<?> argType = method.getParameterTypes()[i];
            if (this.argumentTypes.get(i).isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    private boolean matchInheritanceVisibility(Method method) {
        return Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers());
    }

    private boolean matchNotOverridden(Method method, List<Method> methods) {
        for (Method meth : methods) {
            if (!this.methodEquality(meth, method)) continue;
            return false;
        }
        return true;
    }

    private boolean methodEquality(Method method1, Method method2) {
        if (method1.getName().equals(method2.getName())) {
            Class<?>[] params2;
            if (!method1.getReturnType().equals(method2.getReturnType())) {
                return false;
            }
            Class<?>[] params1 = method1.getParameterTypes();
            if (params1.length == (params2 = method2.getParameterTypes()).length) {
                for (int i = 0; i < params1.length; ++i) {
                    if (params1[i] == params2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void traverse(List<Method> methods, Class<?> clazz) {
        Method[] list;
        for (Method method : list = clazz.getDeclaredMethods()) {
            if (!this.matchReturnType(method) || !this.matchArgumentTypes(method) || !this.matchInheritanceVisibility(method) || !this.matchNotOverridden(method, methods)) continue;
            methods.add(method);
        }
        if (clazz.getSuperclass() != null) {
            this.traverse(methods, clazz.getSuperclass());
        }
    }
}

