/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.composite.CompositeManager;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFactory
extends ComponentFactory
implements TrackerCustomizer {
    protected Tracker m_tracker;

    public CompositeFactory(BundleContext context, Element metadata) throws ConfigurationException {
        super(context, metadata);
    }

    public void check(Element metadata) throws ConfigurationException {
        String name = metadata.getAttribute("name");
        if (name == null) {
            throw new ConfigurationException("A composite needs a name : " + metadata);
        }
    }

    public String getClassName() {
        return null;
    }

    public List<IPojoFactory.RequiredHandler> getRequiredHandlerList() {
        IPojoFactory.RequiredHandler req;
        Element[] elems;
        ArrayList<IPojoFactory.RequiredHandler> list = new ArrayList<IPojoFactory.RequiredHandler>();
        for (Element current : elems = this.m_componentMetadata.getElements()) {
            IPojoFactory.RequiredHandler req2 = new IPojoFactory.RequiredHandler((IPojoFactory)this, current.getName(), current.getNameSpace());
            if (list.contains(req2)) continue;
            list.add(req2);
        }
        String arch = this.m_componentMetadata.getAttribute("architecture");
        if ((arch == null || arch.equalsIgnoreCase("true")) && !list.contains(req = new IPojoFactory.RequiredHandler((IPojoFactory)this, "architecture", null))) {
            list.add(req);
        }
        return list;
    }

    public synchronized void stopping() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
        }
        this.m_tracker = null;
    }

    public synchronized void starting() {
        if (this.m_requiredHandlers.size() != 0) {
            try {
                String filter = "(&(objectClass=" + HandlerFactory.class.getName() + ")" + "(" + "handler.type" + "=" + "composite" + ")" + "(factory.state=1)" + ")";
                this.m_tracker = new Tracker(this.m_context, this.m_context.createFilter(filter), (TrackerCustomizer)this);
                this.m_tracker.open();
            }
            catch (InvalidSyntaxException e) {
                this.m_logger.log(1, "A factory filter is not valid: " + e.getMessage());
                this.stop();
            }
        }
    }

    public ComponentInstance createInstance(Dictionary configuration, IPojoContext context, HandlerManager[] handlers) throws ConfigurationException {
        CompositeManager inst = new CompositeManager(this, (BundleContext)context, handlers);
        inst.configure(this.m_componentMetadata, configuration);
        inst.start();
        return inst;
    }

    public synchronized void reconfigure(Dictionary properties) throws UnacceptableConfiguration, MissingHandlerException {
        ComponentInstance instance;
        if (properties == null || properties.get("instance.name") == null && properties.get("name") == null) {
            throw new UnacceptableConfiguration("The configuration does not contains the \"instance.name\" property");
        }
        String name = (String)properties.get("instance.name");
        if (name == null) {
            name = (String)properties.get("name");
        }
        if ((instance = (ComponentInstance)this.m_componentInstances.get(name)) == null) {
            return;
        }
        instance.reconfigure(properties);
    }

    public String getFactoryName() {
        return this.m_componentMetadata.getAttribute("name");
    }
}

