/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.arch;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.shell.Command;

public class ArchCommandImpl
implements Command,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_archs;
    private Architecture[] m_archs;
    private boolean __Fm_factories;
    private Factory[] m_factories;
    private boolean __Fm_handlers;
    private HandlerFactory[] m_handlers;
    static /* synthetic */ Class class$org$apache$felix$ipojo$IPojoFactory;
    private boolean __MgetName;
    private boolean __MgetUsage;
    private boolean __MgetShortDescription;
    private boolean __Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream;
    private boolean __MprintStats$java_io_PrintStream;
    private boolean __MprintInstances$java_io_PrintStream;
    private boolean __MprintInstance$java_lang_String$java_io_PrintStream$java_io_PrintStream;
    private boolean __MprintFactories$java_io_PrintStream;
    private boolean __MprintFactory$java_lang_String$java_io_PrintStream$java_io_PrintStream;
    private boolean __MprintHandlers$java_io_PrintStream;

    Architecture[] __getm_archs() {
        if (!this.__Fm_archs) {
            return this.m_archs;
        }
        return (Architecture[])this.__IM.onGet((Object)this, "m_archs");
    }

    void __setm_archs(Architecture[] architectureArray) {
        if (!this.__Fm_archs) {
            this.m_archs = architectureArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_archs", (Object)architectureArray);
    }

    Factory[] __getm_factories() {
        if (!this.__Fm_factories) {
            return this.m_factories;
        }
        return (Factory[])this.__IM.onGet((Object)this, "m_factories");
    }

    void __setm_factories(Factory[] factoryArray) {
        if (!this.__Fm_factories) {
            this.m_factories = factoryArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_factories", (Object)factoryArray);
    }

    HandlerFactory[] __getm_handlers() {
        if (!this.__Fm_handlers) {
            return this.m_handlers;
        }
        return (HandlerFactory[])this.__IM.onGet((Object)this, "m_handlers");
    }

    void __setm_handlers(HandlerFactory[] handlerFactoryArray) {
        if (!this.__Fm_handlers) {
            this.m_handlers = handlerFactoryArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_handlers", (Object)handlerFactoryArray);
    }

    public ArchCommandImpl() {
        this(null);
    }

    private ArchCommandImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public String getName() {
        String string;
        if (!this.__MgetName) {
            return this.__getName();
        }
        try {
            this.__IM.onEntry((Object)this, "getName", new Object[0]);
            string = this.__getName();
            this.__IM.onExit((Object)this, "getName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getName() {
        return "arch";
    }

    public String getUsage() {
        String string;
        if (!this.__MgetUsage) {
            return this.__getUsage();
        }
        try {
            this.__IM.onEntry((Object)this, "getUsage", new Object[0]);
            string = this.__getUsage();
            this.__IM.onExit((Object)this, "getUsage", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getUsage", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getUsage() {
        return "arch [-factories] [-instances] [-handlers] [-factory factory_name] [-instance instance_name]";
    }

    public String getShortDescription() {
        String string;
        if (!this.__MgetShortDescription) {
            return this.__getShortDescription();
        }
        try {
            this.__IM.onEntry((Object)this, "getShortDescription", new Object[0]);
            string = this.__getShortDescription();
            this.__IM.onExit((Object)this, "getShortDescription", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getShortDescription", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getShortDescription() {
        return "Architecture command : display the architecture";
    }

    public void execute(String string, PrintStream printStream, PrintStream printStream2) {
        if (!this.__Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream) {
            this.__execute(string, printStream, printStream2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", new Object[]{string, printStream, printStream2});
            this.__execute(string, printStream, printStream2);
            this.__IM.onExit((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __execute(String line, PrintStream out, PrintStream err) {
        String line2 = line.substring("arch".length()).trim();
        if (line2.equalsIgnoreCase("-instances") || line2.length() == 0) {
            this.printInstances(out);
            return;
        }
        if (line2.equalsIgnoreCase("-factories")) {
            this.printFactories(out);
            return;
        }
        if (line2.startsWith("-factory")) {
            String name = line2.substring("-factory".length()).trim();
            this.printFactory(name, out, err);
            return;
        }
        if (line2.startsWith("-instance")) {
            String name = line2.substring("-instance".length()).trim();
            this.printInstance(name, out, err);
            return;
        }
        if (line2.startsWith("-handlers")) {
            this.printHandlers(out);
            return;
        }
        if (line2.startsWith("-stats")) {
            this.printStats(out);
            return;
        }
        err.println(this.getUsage());
    }

    private void printStats(PrintStream printStream) {
        if (!this.__MprintStats$java_io_PrintStream) {
            this.__printStats(printStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printStats$java_io_PrintStream", new Object[]{printStream});
            this.__printStats(printStream);
            this.__IM.onExit((Object)this, "printStats$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printStats$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __printStats(PrintStream out) {
        try {
            Field field = (class$org$apache$felix$ipojo$IPojoFactory == null ? (class$org$apache$felix$ipojo$IPojoFactory = ArchCommandImpl.class$("org.apache.felix.ipojo.IPojoFactory")) : class$org$apache$felix$ipojo$IPojoFactory).getDeclaredField("INSTANCE_NAME");
            field.setAccessible(true);
            List names = (List)field.get(null);
            out.println("Number of living instances : " + names.size());
            out.println("Created instances : " + names);
        }
        catch (SecurityException e) {
            out.println("Cannot compute stats : " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            out.println("Cannot compute stats : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            out.println("Cannot compute stats : " + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            out.println("Cannot compute stats : " + e.getMessage());
        }
    }

    private void printInstances(PrintStream printStream) {
        if (!this.__MprintInstances$java_io_PrintStream) {
            this.__printInstances(printStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printInstances$java_io_PrintStream", new Object[]{printStream});
            this.__printInstances(printStream);
            this.__IM.onExit((Object)this, "printInstances$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printInstances$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __printInstances(PrintStream out) {
        for (int i = 0; i < this.__getm_archs().length; ++i) {
            InstanceDescription instance = this.__getm_archs()[i].getInstanceDescription();
            if (instance.getState() == 2) {
                out.println("Instance " + instance.getName() + " -> valid");
            }
            if (instance.getState() == 1) {
                out.println("Instance " + instance.getName() + " -> invalid");
            }
            if (instance.getState() != 0) continue;
            out.println("Instance " + instance.getName() + " -> stopped");
        }
    }

    private void printInstance(String string, PrintStream printStream, PrintStream printStream2) {
        if (!this.__MprintInstance$java_lang_String$java_io_PrintStream$java_io_PrintStream) {
            this.__printInstance(string, printStream, printStream2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printInstance$java_lang_String$java_io_PrintStream$java_io_PrintStream", new Object[]{string, printStream, printStream2});
            this.__printInstance(string, printStream, printStream2);
            this.__IM.onExit((Object)this, "printInstance$java_lang_String$java_io_PrintStream$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printInstance$java_lang_String$java_io_PrintStream$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __printInstance(String name, PrintStream out, PrintStream err) {
        for (int i = 0; i < this.__getm_archs().length; ++i) {
            InstanceDescription instance = this.__getm_archs()[i].getInstanceDescription();
            if (!instance.getName().equalsIgnoreCase(name)) continue;
            out.println(instance.getDescription());
            return;
        }
        err.println("Instance " + name + " not found");
    }

    private void printFactories(PrintStream printStream) {
        if (!this.__MprintFactories$java_io_PrintStream) {
            this.__printFactories(printStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printFactories$java_io_PrintStream", new Object[]{printStream});
            this.__printFactories(printStream);
            this.__IM.onExit((Object)this, "printFactories$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printFactories$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __printFactories(PrintStream out) {
        for (int i = 0; i < this.__getm_factories().length; ++i) {
            if (this.__getm_factories()[i].getMissingHandlers().size() == 0) {
                out.println("Factory " + this.__getm_factories()[i].getName() + " (VALID)");
                continue;
            }
            out.println("Factory " + this.__getm_factories()[i].getName() + " (INVALID : " + this.__getm_factories()[i].getMissingHandlers() + ")");
        }
    }

    private void printFactory(String string, PrintStream printStream, PrintStream printStream2) {
        if (!this.__MprintFactory$java_lang_String$java_io_PrintStream$java_io_PrintStream) {
            this.__printFactory(string, printStream, printStream2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printFactory$java_lang_String$java_io_PrintStream$java_io_PrintStream", new Object[]{string, printStream, printStream2});
            this.__printFactory(string, printStream, printStream2);
            this.__IM.onExit((Object)this, "printFactory$java_lang_String$java_io_PrintStream$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printFactory$java_lang_String$java_io_PrintStream$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __printFactory(String name, PrintStream out, PrintStream err) {
        boolean found = false;
        for (int i = 0; i < this.__getm_factories().length; ++i) {
            if (!this.__getm_factories()[i].getName().equalsIgnoreCase(name)) continue;
            if (found) {
                out.println();
            }
            out.println(this.__getm_factories()[i].getDescription());
            found = true;
        }
        if (!found) {
            err.println("Factory " + name + " not found");
        }
    }

    private void printHandlers(PrintStream printStream) {
        if (!this.__MprintHandlers$java_io_PrintStream) {
            this.__printHandlers(printStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printHandlers$java_io_PrintStream", new Object[]{printStream});
            this.__printHandlers(printStream);
            this.__IM.onExit((Object)this, "printHandlers$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printHandlers$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __printHandlers(PrintStream out) {
        for (int i = 0; i < this.__getm_handlers().length; ++i) {
            String name = this.__getm_handlers()[i].getHandlerName();
            if ("composite".equals(this.__getm_handlers()[i].getType())) {
                name = name + " [composite]";
            }
            if (this.__getm_handlers()[i].getMissingHandlers().size() == 0) {
                out.println("Handler " + name + " (VALID)");
                continue;
            }
            out.println("Handler " + name + " (INVALID : " + this.__getm_handlers()[i].getMissingHandlers() + ")");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_handlers")) {
                this.__Fm_handlers = true;
            }
            if (set.contains("m_archs")) {
                this.__Fm_archs = true;
            }
            if (set.contains("m_factories")) {
                this.__Fm_factories = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getName")) {
                this.__MgetName = true;
            }
            if (set.contains("getUsage")) {
                this.__MgetUsage = true;
            }
            if (set.contains("getShortDescription")) {
                this.__MgetShortDescription = true;
            }
            if (set.contains("execute$java_lang_String$java_io_PrintStream$java_io_PrintStream")) {
                this.__Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream = true;
            }
            if (set.contains("printStats$java_io_PrintStream")) {
                this.__MprintStats$java_io_PrintStream = true;
            }
            if (set.contains("printInstances$java_io_PrintStream")) {
                this.__MprintInstances$java_io_PrintStream = true;
            }
            if (set.contains("printInstance$java_lang_String$java_io_PrintStream$java_io_PrintStream")) {
                this.__MprintInstance$java_lang_String$java_io_PrintStream$java_io_PrintStream = true;
            }
            if (set.contains("printFactories$java_io_PrintStream")) {
                this.__MprintFactories$java_io_PrintStream = true;
            }
            if (set.contains("printFactory$java_lang_String$java_io_PrintStream$java_io_PrintStream")) {
                this.__MprintFactory$java_lang_String$java_io_PrintStream$java_io_PrintStream = true;
            }
            if (set.contains("printHandlers$java_io_PrintStream")) {
                this.__MprintHandlers$java_io_PrintStream = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

