/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api.composite;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.felix.ipojo.api.HandlerConfiguration;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class InstantiatedService
implements HandlerConfiguration {
    private String m_specification;
    private String m_filter;
    private boolean m_optional;
    private boolean m_aggregate;
    private int m_policy = 0;
    private String m_comparator;
    private List m_conf = new ArrayList();

    public Element getElement() {
        this.ensureValidity();
        Element dep = new Element("subservice", "");
        dep.addAttribute(new Attribute("action", "instantiate"));
        dep.addAttribute(new Attribute("specification", this.m_specification));
        if (this.m_filter != null) {
            dep.addAttribute(new Attribute("filter", this.m_filter));
        }
        if (this.m_comparator != null) {
            dep.addAttribute(new Attribute("comparator", this.m_comparator));
        }
        if (this.m_optional) {
            dep.addAttribute(new Attribute("optional", "true"));
        }
        if (this.m_aggregate) {
            dep.addAttribute(new Attribute("aggregate", "true"));
        }
        if (this.m_policy == 0) {
            dep.addAttribute(new Attribute("policy", "dynamic"));
        } else if (this.m_policy == 1) {
            dep.addAttribute(new Attribute("policy", "static"));
        } else if (this.m_policy == 2) {
            dep.addAttribute(new Attribute("policy", "dynamic-priority"));
        }
        for (int i = 0; i < this.m_conf.size(); ++i) {
            Element elem = (Element)this.m_conf.get(i);
            dep.addElement(elem);
        }
        return dep;
    }

    public InstantiatedService addProperty(String name, String value) {
        Element elem = new Element("property", "");
        this.m_conf.add(elem);
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("value", value));
        return this;
    }

    public InstantiatedService addProperty(String name, List values) {
        Element elem = new Element("property", "");
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("type", "list"));
        this.m_conf.add(elem);
        for (int i = 0; i < values.size(); ++i) {
            Object obj = values.get(i);
            Element e = new Element("property", "");
            elem.addElement(e);
            if (!(obj instanceof String)) {
                throw new UnsupportedOperationException("Complex properties are not supported yet");
            }
            e.addAttribute(new Attribute("value", obj.toString()));
        }
        return this;
    }

    public InstantiatedService addProperty(String name, String[] values) {
        Element elem = new Element("property", "");
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("type", "array"));
        this.m_conf.add(elem);
        for (int i = 0; i < values.length; ++i) {
            String obj = values[i];
            Element e = new Element("property", "");
            elem.addElement(e);
            e.addAttribute(new Attribute("value", obj.toString()));
        }
        return this;
    }

    public InstantiatedService addProperty(String name, Vector values) {
        Element elem = new Element("property", "");
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("type", "vector"));
        this.m_conf.add(elem);
        for (int i = 0; i < values.size(); ++i) {
            Object obj = values.get(i);
            Element e = new Element("property", "");
            elem.addElement(e);
            if (!(obj instanceof String)) {
                throw new UnsupportedOperationException("Complex properties are not supported yet");
            }
            e.addAttribute(new Attribute("value", obj.toString()));
        }
        return this;
    }

    public InstantiatedService addProperty(String name, Map values) {
        Element elem = new Element("property", "");
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("type", "map"));
        this.m_conf.add(elem);
        Set entries = values.entrySet();
        for (Map.Entry entry : entries) {
            Element e = new Element("property", "");
            elem.addElement(e);
            String n = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String) {
                e.addAttribute(new Attribute("name", n));
                e.addAttribute(new Attribute("value", v.toString()));
                continue;
            }
            throw new UnsupportedOperationException("Complex properties are not supported yet");
        }
        return this;
    }

    public InstantiatedService addProperty(String name, Dictionary values) {
        Element elem = new Element("property", "");
        elem.addAttribute(new Attribute("name", name));
        elem.addAttribute(new Attribute("type", "dictionary"));
        this.m_conf.add(elem);
        Enumeration e = values.keys();
        while (e.hasMoreElements()) {
            Element el = new Element("property", "");
            elem.addElement(el);
            String n = (String)e.nextElement();
            Object v = values.get(n);
            if (v instanceof String) {
                el.addAttribute(new Attribute("name", n));
                el.addAttribute(new Attribute("value", v.toString()));
                continue;
            }
            throw new UnsupportedOperationException("Complex properties are not supported yet");
        }
        return this;
    }

    public InstantiatedService setSpecification(String spec) {
        this.m_specification = spec;
        return this;
    }

    public InstantiatedService setFilter(String filter) {
        this.m_filter = filter;
        return this;
    }

    public InstantiatedService setOptional(boolean opt) {
        this.m_optional = opt;
        return this;
    }

    public InstantiatedService setAggregate(boolean agg) {
        this.m_aggregate = agg;
        return this;
    }

    public InstantiatedService setBindingPolicy(int policy) {
        this.m_policy = policy;
        return this;
    }

    public InstantiatedService setComparator(String cmp) {
        this.m_comparator = cmp;
        return this;
    }

    private void ensureValidity() {
        if (this.m_specification == null) {
            throw new IllegalStateException("The specification of the instantiated service must be set");
        }
        if (this.m_policy != 0 && this.m_policy != 1 && this.m_policy != 2) {
            throw new IllegalStateException("Unknown binding policy : " + this.m_policy);
        }
    }
}

