/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.render;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.manipulator.render.ManipulatedMetadataFilter;
import org.apache.felix.ipojo.manipulator.render.MetadataFilter;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class MetadataRenderer {
    private List<MetadataFilter> m_filters = new ArrayList<MetadataFilter>();

    public MetadataRenderer() {
        this.addMetadataFilter(new ManipulatedMetadataFilter());
    }

    public void addMetadataFilter(MetadataFilter filter) {
        this.m_filters.add(filter);
    }

    public String render(Element element) {
        StringBuilder builder = new StringBuilder();
        this.renderElement(element, builder);
        return builder.toString();
    }

    private void renderElement(Element element, StringBuilder builder) {
        if (!this.isFiltered(element)) {
            this.startElement(element, builder);
            for (Attribute attribute : element.getAttributes()) {
                this.renderAttribute(attribute, builder);
            }
            for (Element child : element.getElements()) {
                this.renderElement(child, builder);
            }
            this.endElement(builder);
        }
    }

    private void startElement(Element element, StringBuilder builder) {
        String namespace = "";
        if (element.getNameSpace() != null) {
            namespace = element.getNameSpace() + ":";
        }
        builder.append(namespace).append(element.getName()).append(" { ");
    }

    private void endElement(StringBuilder builder) {
        builder.append("}");
    }

    private void renderAttribute(Attribute current, StringBuilder builder) {
        String namespace = "";
        if (current.getNameSpace() != null) {
            namespace = current.getNameSpace() + ":";
        }
        builder.append("$").append(namespace).append(current.getName()).append("=").append(this.quoted(current.getValue())).append(" ");
    }

    private String quoted(String value) {
        return "\"" + value + "\"";
    }

    private boolean isFiltered(Element element) {
        for (MetadataFilter filter : this.m_filters) {
            if (!filter.accept(element)) continue;
            return true;
        }
        return false;
    }
}

