/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.substrate.impl.json;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.atomos.utils.substrate.api.reflect.ReflectionClassConfig;
import org.apache.felix.atomos.utils.substrate.api.reflect.ReflectionConfiguration;
import org.apache.felix.atomos.utils.substrate.impl.config.DefaultReflectionClassConfiguration;

public class ReflectJsonUtil {
    private static String _NAME_PATTERN = "\"name\":\"%s\"";
    private static String CLASS_END = "}";
    private static String CLASS_NAME = _NAME_PATTERN;
    private static String CLASS_START = "{\n";
    private static String COMMA_ENTER = ",\n";
    private static String COMMA_SPACE = ", ";
    private static String COMPONENT_CONSTRUCTOR = "\"allPublicConstructors\" : true";
    private static String COMPONENT_FIELDS = "\"allPublicFields\" : true";
    private static String COMPONENT_METHODS = "\"allPublicMethods\" : true";
    private static String CONSTRUCTOR_METHOD_NAME = "<init>";
    private static String FIELD_NAME = _NAME_PATTERN;
    private static String FIELDS_END = "]";
    private static String FIELDS_START = "\"fields\" : [\n";
    private static String METHOD_NAME = _NAME_PATTERN;
    private static String METHODS_END = FIELDS_END;
    private static String METHODS_START = "\"methods\" : [\n";
    private static String PARAMETER_TYPE = "\"parameterTypes\":[%s]";

    private static Object ind(int num) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            indent.append("  ");
        }
        return indent.toString();
    }

    public static String json(List<ReflectionClassConfig> reflectConfigs) {
        StringBuilder builder = new StringBuilder();
        builder.append('[').append('\n');
        AtomicReference<String> comma = new AtomicReference<String>("");
        reflectConfigs.stream().sorted((o1, o2) -> o1.getClassName().compareTo(o2.getClassName())).forEachOrdered(config -> builder.append(comma.getAndSet(COMMA_ENTER)).append(ReflectJsonUtil.json(config)));
        builder.append('\n').append(']');
        return builder.toString();
    }

    public static String json(ReflectionClassConfig reflectConfig) {
        StringBuilder builder = new StringBuilder();
        builder.append(ReflectJsonUtil.ind(1)).append(CLASS_START);
        builder.append(ReflectJsonUtil.ind(2)).append(String.format(CLASS_NAME, reflectConfig.getClassName()));
        AtomicReference<String> comma = new AtomicReference<String>("");
        if (!reflectConfig.getFields().isEmpty()) {
            builder.append(COMMA_ENTER).append(ReflectJsonUtil.ind(2)).append(FIELDS_START);
            reflectConfig.getFields().stream().sorted(DefaultReflectionClassConfiguration.fc).forEachOrdered(f -> builder.append(comma.getAndSet(COMMA_ENTER)).append(ReflectJsonUtil.ind(3)).append("{").append(String.format(FIELD_NAME, f.getFieldName())).append("}"));
            builder.append('\n').append(ReflectJsonUtil.ind(2)).append(FIELDS_END);
        }
        comma.set("");
        if (!reflectConfig.getMethods().isEmpty() || !reflectConfig.getConstructors().isEmpty()) {
            builder.append(COMMA_ENTER).append(ReflectJsonUtil.ind(2)).append(METHODS_START);
            reflectConfig.getConstructors().stream().sorted(DefaultReflectionClassConfiguration.cc).forEachOrdered(c -> {
                builder.append(comma.getAndSet(COMMA_ENTER)).append(ReflectJsonUtil.ind(3)).append("{").append(String.format(METHOD_NAME, CONSTRUCTOR_METHOD_NAME));
                if (c.getMethodParameterTypes() != null) {
                    Object types = ((Stream)Stream.of(c.getMethodParameterTypes()).sequential()).collect(Collectors.joining("\",\""));
                    if (!((String)types).isEmpty()) {
                        types = "\"" + (String)types + "\"";
                    }
                    builder.append(COMMA_SPACE).append(String.format(PARAMETER_TYPE, types));
                }
                builder.append("}");
            });
            reflectConfig.getMethods().stream().sorted(DefaultReflectionClassConfiguration.mc).forEachOrdered(m -> {
                builder.append(comma.getAndSet(COMMA_ENTER)).append(ReflectJsonUtil.ind(3)).append("{").append(String.format(METHOD_NAME, m.getName()));
                if (m.getMethodParameterTypes() != null) {
                    Object types = ((Stream)Stream.of(m.getMethodParameterTypes()).sequential()).collect(Collectors.joining("\",\""));
                    if (!((String)types).isEmpty()) {
                        types = "\"" + (String)types + "\"";
                    }
                    builder.append(COMMA_SPACE).append(String.format(PARAMETER_TYPE, types));
                }
                builder.append("}");
            });
            builder.append('\n').append(ReflectJsonUtil.ind(2)).append(METHODS_END);
        }
        builder.append('\n').append(ReflectJsonUtil.ind(1)).append(CLASS_END);
        return builder.toString();
    }

    public static String json(ReflectionConfiguration reflectConfig) {
        return ReflectJsonUtil.json(reflectConfig.getClassConfigs());
    }
}

