/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.connect.ConnectContent;

public class ConnectContentJar
implements ConnectContent {
    final Supplier<ZipFile> zipSupplier;
    final Consumer<Supplier<ZipFile>> closer;
    final Supplier<Optional<Map<String, String>>> headers;

    public ConnectContentJar(Supplier<ZipFile> zipSupplier, Consumer<Supplier<ZipFile>> closer, Supplier<Optional<Map<String, String>>> headers) {
        this.zipSupplier = zipSupplier;
        this.closer = closer;
        this.headers = headers;
    }

    public void open() throws IOException {
        this.zipSupplier.get();
    }

    public void close() throws IOException {
        this.closer.accept(this.zipSupplier);
    }

    public Optional<ClassLoader> getClassLoader() {
        return Optional.of(this.getClass().getClassLoader());
    }

    public Iterable<String> getEntries() throws IOException {
        return () -> new Iterator<String>(){
            final Enumeration entries;
            {
                this.entries = ConnectContentJar.this.zipSupplier.get().entries();
            }

            @Override
            public boolean hasNext() {
                return this.entries.hasMoreElements();
            }

            @Override
            public String next() {
                return ((ZipEntry)this.entries.nextElement()).getName();
            }
        };
    }

    public Optional<ConnectContent.ConnectEntry> getEntry(String name) {
        ZipEntry entry = this.zipSupplier.get().getEntry(name);
        if (entry != null) {
            return Optional.of(new JarConnectEntry(entry));
        }
        return Optional.empty();
    }

    public Optional<Map<String, String>> getHeaders() {
        return this.headers.get();
    }

    class JarConnectEntry
    implements ConnectContent.ConnectEntry {
        final ZipEntry entry;

        public JarConnectEntry(ZipEntry entry) {
            this.entry = entry;
        }

        public long getContentLength() {
            return this.entry.getSize();
        }

        public InputStream getInputStream() throws IOException {
            return ConnectContentJar.this.zipSupplier.get().getInputStream(this.entry);
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public String getName() {
            return this.entry.getName();
        }
    }
}

